/*
 * Decompiled with CFR 0.152.
 */
package org.jfr.examples;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.jfr.parser.GenericStreamDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;

public class JpedalLabel
extends JPanel {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    private int alignment = 0;
    private String text = "";
    ObjectStore localStore = new ObjectStore();
    DynamicVectorRenderer dvr = new DynamicVectorRenderer(1, true, 1000, this.localStore);
    GenericStreamDecoder painter = new GenericStreamDecoder(this.dvr);
    private PdfPageData pageData = new PdfPageData();
    int pageWidth = 600;
    int pageHeight = 800;
    int rotation = 0;
    int insetW = 5;
    int insetH = 5;
    int rightMargin = 600;
    float scaling = 1.0f;
    String[] fonts;
    private Rectangle[] areas;
    private String font = "";

    public JpedalLabel() {
        this.setSystemFonts();
    }

    public JpedalLabel(String string) {
        this.setSystemFonts();
        this.text = string;
    }

    public JpedalLabel(String string, int n) {
        this.setSystemFonts();
        this.text = string;
        this.alignment = n;
    }

    public void paint(Graphics graphics) {
        this.clearLabel();
        switch (this.alignment) {
            case 0: {
                this.renderLeftAlignedText(this.text);
                break;
            }
            case 1: {
                this.renderRightAlignedText(this.text);
                break;
            }
            case 2: {
                this.renderCenterAlignedText(this.text);
                break;
            }
            default: {
                this.renderLeftAlignedText(this.text);
            }
        }
        super.paint(graphics);
    }

    public void clearLabel() {
        this.painter.setCurrentXpt(this.painter.getLeftMargin());
        this.dvr.flush();
    }

    public void renderRightAlignedText(String string) {
        System.out.println("To Be Implemented");
    }

    public void renderCenterAlignedText(String string) {
        System.out.println("To Be Implemented");
    }

    public void renderLeftAlignedText(String string) {
        double d = this.painter.getRightMargin();
        double d2 = this.painter.getLeftMargin();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            double d3;
            String string2 = stringTokenizer.nextToken();
            double d4 = this.painter.getCurrentXpt();
            if (d4 + (d3 = this.painter.getStringLength(string2)) > d) {
                this.painter.lineDown(1);
                this.painter.setCurrentXpt(d2);
            }
            d4 = this.painter.setText(string2);
            this.painter.setText(" ");
        }
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        int n = (int)((float)this.insetW + (float)this.pageWidth * this.scaling);
        int n2 = (int)((float)this.insetH + (float)this.pageHeight * this.scaling);
        dimension = this.rotation == 90 | this.rotation == 270 ? new Dimension(n2, n) : new Dimension(n, n2);
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    private AffineTransform getScalingForImage(int n, int n2, float f) {
        double d = (float)this.pageData.getMediaBoxX(n) * f;
        double d2 = (float)this.pageData.getMediaBoxY(n) * f;
        double d3 = (float)this.pageData.getMediaBoxWidth(n) * f;
        double d4 = (float)this.pageData.getMediaBoxHeight(n) * f;
        double d5 = (float)this.pageData.getCropBoxWidth(n) * f;
        double d6 = (float)this.pageData.getCropBoxHeight(n) * f;
        double d7 = (float)this.pageData.getCropBoxX(n) * f;
        double d8 = (float)this.pageData.getCropBoxY(n) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = (int)(d5 + (d7 - d));
        int n4 = (int)(d6 + (d8 - d2));
        if (n2 == 270) {
            affineTransform.rotate(-1.5707963267948966, n3 / 2, n4 / 2);
            double d9 = affineTransform.getTranslateX();
            double d10 = affineTransform.getTranslateY();
            affineTransform.translate((double)n4 - d10, -d9);
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d7 + d), -(d4 - d6 - (d8 - d2)));
        } else if (n2 == 180) {
            affineTransform.rotate(Math.PI, n3 / 2, n4 / 2);
            affineTransform.translate(-(d7 + d), (double)n4 + (d8 + d2) - (d4 - d6 - (d8 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n2 == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d8 + d2 - (d4 - d6 - (d8 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d4 - d6 - (d8 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = this.getScalingForImage(0, 0, this.scaling);
        AffineTransform affineTransform3 = graphics2D.getTransform();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        graphics2D.transform(affineTransform2);
        this.dvr.paint(graphics2D, null, null, null, false, true);
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        if (this.areas != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setColor(Color.blue);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            if (this.areas != null) {
                int n = this.areas.length;
                for (int i = 0; i < n; ++i) {
                    if (this.areas[i] == null) continue;
                    graphics2D.fillRect(this.areas[i].x, this.areas[i].y, this.areas[i].width, this.areas[i].height);
                }
            }
            graphics2D.setComposite(composite);
        }
        graphics2D.setTransform(affineTransform3);
    }

    public void setFont(String string, int n) {
        try {
            this.font = string;
            this.painter.setFont(string, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String[] getFonts() {
        return this.fonts;
    }

    public void setFonts(String[] stringArray) {
        this.fonts = stringArray;
    }

    public void setSystemFonts() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 48;
        this.fonts = this.painter.getFontList();
        if (this.fonts == null || this.fonts.length < 1) {
            try {
                throw new Exception("No fonts configured");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.painter.setRightMargin(this.rightMargin);
        this.painter.setLeftMargin(0.0);
        this.painter.setTextLocationMatrix(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
        this.painter.setForeground(new PdfColor(0, 0, 0));
        try {
            this.painter.setFont(this.fonts[0], n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.repaint();
    }
}

