/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceNColorSpace
extends SeparationColorSpace {
    public DeviceNColorSpace() {
    }

    public DeviceNColorSpace(PdfObjectReader pdfObjectReader, PdfObject pdfObject, PdfObject pdfObject2) {
        this.value = 960981604;
        this.processColorToken(pdfObjectReader, pdfObject, pdfObject2);
    }

    public void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        this.setColor(fArray, n);
    }

    public void setColor(float[] fArray, int n) {
        if (this.cmykMapping == 1 && n == 3) {
            float[] fArray2 = new float[]{0.0f, fArray[0], fArray[1], fArray[2]};
            this.altCS.setColor(fArray2, fArray2.length);
        } else if (this.cmykMapping == 2 && n == 3) {
            float[] fArray3 = new float[]{fArray[0], fArray[1], fArray[2], 0.0f};
            this.altCS.setColor(fArray3, fArray3.length);
        } else if (this.cmykMapping == 4 && n == 3) {
            float[] fArray4 = new float[]{fArray[0], fArray[1], 0.0f, fArray[2]};
            this.altCS.setColor(fArray4, fArray4.length);
        } else {
            try {
                float[] fArray5 = this.colorMapper.getOperandFloat(fArray);
                this.altCS.setColor(fArray5, fArray5.length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.createImage(n, n2, byArray);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert DeviceN colorspace data: " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            int n5 = raster.getWidth();
            int n6 = raster.getHeight();
            raster = this.cleanupRaster(raster, 0, n3, n4, this.componentCount);
            n5 = raster.getWidth();
            n6 = raster.getHeight();
            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
            bufferedImage = this.createImage(n5, n6, dataBufferByte.getData());
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            exception.printStackTrace();
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, byte[] byArray) {
        byte[] byArray2 = new byte[n * n2 * 3];
        int n3 = byArray.length;
        int n4 = byArray.length / this.componentCount;
        float[] fArray = new float[this.componentCount];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4 && n5 < n3; ++i) {
            int n7;
            for (n7 = 0; n7 < this.componentCount; ++n7) {
                fArray[n7] = (float)(byArray[n5] & 0xFF) / 255.0f;
                ++n5;
            }
            this.setColor(fArray, this.componentCount);
            n7 = this.altCS.currentColor.getRGB();
            byArray2[n6] = (byte)(n7 >> 16 & 0xFF);
            byArray2[n6 + 1] = (byte)(n7 >> 8 & 0xFF);
            byArray2[n6 + 2] = (byte)(n7 & 0xFF);
            n6 += 3;
        }
        int[] nArray = new int[]{0, 1, 2};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

