/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfCIDEncodings;
import org.jpedal.objects.raw.PdfFontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;

public class PdfFont
implements Serializable {
    public Font javaFont = null;
    protected String embeddedFontName = null;
    protected String embeddedFamilyName = null;
    protected String copyright = null;
    protected float missingWidth = -1.0f;
    public PdfJavaGlyphs glyphs = new PdfJavaGlyphs();
    private String[] cachedValue = new String[256];
    private static final int[] powers = new int[]{1, 16, 256, 4096};
    protected String substituteFont = null;
    protected boolean renderPage = false;
    private static final float xscale = 0.001f;
    protected int embeddedEnc = 1;
    protected String[] diffs;
    public boolean isFontEmbedded = false;
    protected boolean TTstreamisCID = false;
    protected String fontID = "";
    protected int maxCharCount = 256;
    protected boolean hasEncoding = true;
    private boolean isDoubleByte = false;
    protected int fontTypes;
    protected String substituteFontFile = null;
    protected String substituteFontName = null;
    private int spaceChar = -1;
    private String[] diffTable;
    protected Map diffLookup = null;
    protected int fontFlag = 0;
    private float[] widthTable;
    private float possibleSpaceWidth = -1.0f;
    protected PdfObjectReader currentPdfFile;
    protected ClassLoader loader = this.getClass().getClassLoader();
    public double[] FontMatrix = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    public float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    protected boolean isHex = false;
    private String[] unicodeMappings;
    protected int fontEnc = -1;
    protected boolean isCIDFont = false;
    protected String[] CMAP;
    protected String CIDfontEncoding;
    private float defaultWidth = 1.0f;
    protected boolean isFontSubstituted = false;
    protected boolean hasFontEncoding;
    protected int italicAngle = 0;
    boolean hasMatrixSet = false;
    boolean hasFBoxSet = false;
    private static boolean isCidJarPresent;

    public PdfFont() {
    }

    public void createFont(String string) throws Exception {
    }

    public PdfFont(PdfObjectReader pdfObjectReader) {
        this.init(pdfObjectReader);
    }

    public static void setStandardFontMappings() {
        String string;
        String string2;
        int n;
        int n2 = StandardFonts.files_names.length;
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names_bis[n].toLowerCase();
            if (string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) || FontMappings.fontSubstitutionAliasTable.containsKey(string2)) continue;
            FontMappings.fontSubstitutionAliasTable.put(string2, string);
        }
        for (n = 0; n < n2; ++n) {
            string2 = StandardFonts.files_names[n].toLowerCase();
            if (!string2.equals(string = StandardFonts.javaFonts[n].toLowerCase()) && !FontMappings.fontSubstitutionAliasTable.containsKey(string2)) {
                FontMappings.fontSubstitutionAliasTable.put(string2, string);
            }
            StandardFonts.javaFontList.put(StandardFonts.files_names[n], "x");
        }
        FontMappings.fontSubstitutionAliasTable.put("arialmt", "arial");
        FontMappings.fontSubstitutionAliasTable.put("arial-boldmt", "arialbd");
    }

    public boolean isFontSubstituted() {
        return this.isFontSubstituted;
    }

    public boolean isDoubleByte() {
        return this.isDoubleByte;
    }

    protected final void setCIDFontWidths(String string) {
        string = string.substring(1, string.length() - 1).trim();
        this.widthTable = new float[65536];
        for (int i = 0; i < 65536; ++i) {
            this.widthTable[i] = -1.0f;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " []", true);
        block1: while (stringTokenizer.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
            String string2;
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            int n = Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            if (string2.equals("[")) {
                while (true) {
                    if ((string2 = stringTokenizer.nextToken()).equals(" ")) {
                        continue;
                    }
                    if (string2.equals("]")) continue block1;
                    this.widthTable[n] = Float.parseFloat(string2) / 1000.0f;
                    ++n;
                }
            }
            int n2 = 1 + Integer.parseInt(string2);
            while ((string2 = stringTokenizer.nextToken()).equals(" ")) {
            }
            for (int i = n; i < n2; ++i) {
                this.widthTable[i] = Float.parseFloat(string2) / 1000.0f;
            }
        }
    }

    public final boolean isCIDFont() {
        return this.isCIDFont;
    }

    protected final void init(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
        if (this.isCIDFont) {
            this.maxCharCount = 65536;
        }
        this.glyphs.init(this.maxCharCount, this.isCIDFont);
    }

    private final String getUnicodeMapping(int n) {
        if (this.unicodeMappings == null) {
            return null;
        }
        return this.unicodeMappings[n];
    }

    protected final void putFontEncoding(int n) {
        this.fontEnc = n;
        StandardFonts.checkLoaded(n);
    }

    public final String getUnicodeValue(String string, int n) {
        String string2 = this.getUnicodeMapping(n);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public final String getGlyphValue(int n) {
        if (this.cachedValue[n] != null) {
            return this.cachedValue[n];
        }
        String string = null;
        if (this.isCIDFont) {
            String string2 = this.getUnicodeMapping(n);
            if (string2 != null) {
                string = string2;
            }
            if (string == null) {
                String string3 = this.CIDfontEncoding;
                if (this.diffTable != null) {
                    string = this.diffTable[n];
                } else if (string3 != null) {
                    String string4;
                    if (string3.startsWith("Identity-")) {
                        string = String.valueOf((char)n);
                    } else if (this.CMAP != null && (string4 = this.CMAP[n]) != null) {
                        string = string4;
                    }
                }
                if (string == null) {
                    string = String.valueOf((char)n);
                }
            }
        } else {
            string = this.getStandardGlyphValue(n);
        }
        this.cachedValue[n] = string;
        return string;
    }

    private final void handleCIDEncoding(PdfObject pdfObject) throws PdfFontException {
        boolean bl;
        String string;
        BufferedReader bufferedReader = null;
        boolean bl2 = false;
        int n = pdfObject.getGeneralType(1232564598);
        String string2 = PdfCIDEncodings.getNameForEncoding(n);
        if (string2 == null) {
            string2 = n == 2038913669 ? "Identity-H" : (n == 2038913683 ? "Identity-V" : pdfObject.getGeneralStringValue());
        }
        if ((string = pdfObject.getStringValue(827223669)) != null) {
            byte[] byArray = this.currentPdfFile.readStream(pdfObject, true, true, false, false, false);
            string2 = string;
            bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
            bl2 = true;
        }
        boolean bl3 = bl = n == 2038913669 || n == 2038913683;
        if (bufferedReader == null) {
            this.CIDfontEncoding = string2;
        }
        if (bl) {
            this.isDoubleByte = true;
            this.glyphs.setIsIdentity(true);
        } else {
            Object object;
            if (!isCidJarPresent && bufferedReader == null) {
                isCidJarPresent = true;
                object = PdfFont.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf");
                if (object == null) {
                    throw new PdfFontException("cid.jar not on classpath");
                }
            }
            this.glyphs.setIsIdentity(false);
            this.CMAP = new String[65536];
            this.isDoubleByte = PdfCIDEncodings.isDoubleByte(n);
            try {
                if (bufferedReader == null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.loader.getResourceAsStream("org/jpedal/res/cid/" + string2), "Cp1252"));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("1.Problem reading encoding for CID font " + this.fontID + " encoding=" + string2 + " Check CID.jar installed");
            }
            if (bufferedReader != null) {
                object = "";
                boolean bl4 = false;
                while (true) {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("[PDF] Error reading line from font");
                    }
                    if (object == null) break;
                    if (((String)object).indexOf("endcidrange") != -1) {
                        bl4 = false;
                    }
                    if (bl4) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, " <>[]");
                        boolean bl5 = false;
                        if (((String)object).indexOf(91) != -1) {
                            bl5 = true;
                        }
                        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                        for (int i = n2; i < n3 + 1; ++i) {
                            if (bl5) {
                                n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
                                this.CMAP[i] = String.valueOf((char)n4);
                                continue;
                            }
                            this.CMAP[i] = String.valueOf((char)n4);
                            ++n4;
                        }
                    }
                    if (((String)object).indexOf("begincidrange") == -1) continue;
                    bl4 = true;
                }
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("2.Problem reading encoding for CID font " + this.fontID + ' ' + string2 + " Check CID.jar installed");
            }
        }
    }

    public final String getStandardGlyphValue(int n) {
        String string = this.getUnicodeMapping(n);
        if (string != null) {
            return string;
        }
        String string2 = "";
        int n2 = this.getFontEncoding(true);
        String string3 = this.getMappedChar(n, true);
        if (string3 != null) {
            String string4 = StandardFonts.getUnicodeName(this.fontEnc + string3);
            if (string4 != null) {
                string2 = string4;
            } else {
                string4 = StandardFonts.getUnicodeName(string3);
                if (string4 != null) {
                    string2 = string4;
                } else if (string3.length() == 1) {
                    string2 = string3;
                } else if (string3.length() > 1) {
                    int n3;
                    char c = string3.charAt(0);
                    char c2 = string3.charAt(1);
                    if (c == 'B' | c == 'C' | c == 'c' | c == 'G') {
                        string3 = string3.substring(1);
                        try {
                            n3 = this.isHex ? Integer.valueOf(string3, 16) : Integer.parseInt(string3);
                            string2 = String.valueOf((char)n3);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                    } else {
                        string2 = "";
                    }
                    int n4 = n3 = (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') ? 1 : 0;
                    if (string2.length() == 0 && this.fontTypes == 1228944679 && string3.length() == 2 && n3 != 0) {
                        try {
                            string2 = String.valueOf((char)Integer.parseInt(string3, 16));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string2.length() == 0 && this.fontTypes == 1228944679) {
                        string2 = String.valueOf((char)n);
                    }
                } else {
                    string2 = "";
                }
            }
        } else if (n2 > -1) {
            string2 = StandardFonts.getEncodedChar(n2, n);
        }
        return string2;
    }

    public final Font getJavaFont(int n) {
        String string;
        int n2 = 0;
        boolean bl = false;
        String string2 = null;
        Object var5_5 = null;
        String string3 = string = this.glyphs.fontName;
        if (string != null) {
            string3 = string.toLowerCase();
        }
        if (string3.equals("arialmt")) {
            string = string3 = "arial";
        } else if (string3.equals("arial-boldmt")) {
            string = string3 = "arial Bold";
        }
        if (var5_5 != null) {
            string = var5_5;
            string3 = string.toLowerCase();
        }
        if (PdfJavaGlyphs.fontList != null) {
            int n3 = PdfJavaGlyphs.fontList.length;
            for (int i = 0; i < n3; ++i) {
                System.out.println(PdfJavaGlyphs.fontList[i] + "<>" + string3);
                if (PdfJavaGlyphs.fontList[i].indexOf(string3) == -1) continue;
                bl = true;
                string = PdfJavaGlyphs.fontList[i];
                i = n3;
            }
        }
        if (!bl && string2 == null) {
            String string4 = string.toLowerCase();
            if (string4.indexOf("heavy") != -1) {
                n2 = 1;
            } else if (string4.indexOf("bold") != -1) {
                n2 = 1;
            } else if (string4.indexOf("roman") != -1) {
                n2 = 0;
            }
            if (string4.indexOf("italic") != -1) {
                n2 += 2;
            } else if (string4.indexOf("oblique") != -1) {
                n2 += 2;
            }
        }
        if (bl) {
            return new Font(string, n2, n);
        }
        System.out.println("No match with " + this.glyphs.getBaseFontName() + ' ' + ' ' + string3 + ' ' + string2 + ' ' + n2);
        System.exit(1);
        return null;
    }

    public final void setDefaultDisplayFont(String string) {
        this.glyphs.defaultFont = string;
    }

    public final Font getJavaFontX(int n) {
        return new Font(this.glyphs.font_family_name, this.glyphs.style, n);
    }

    public final String getFontName() {
        StandardFonts.loadStandardFontWidth(this.glyphs.fontName);
        return this.glyphs.fontName;
    }

    public final String getBaseFontName() {
        return this.glyphs.getBaseFontName();
    }

    public final void setBaseFontName(String string) {
        this.glyphs.setBaseFontName(string);
    }

    public final void setFontName(String string) {
        this.glyphs.fontName = string;
    }

    public final float getCurrentFontSpaceWidth() {
        int n = this.spaceChar;
        float f = n != -1 ? this.getWidth(n) : this.possibleSpaceWidth;
        if (f == -1.0f) {
            f = 0.2f;
        }
        return f;
    }

    protected final int getFontEncoding(boolean bl) {
        int n = this.fontEnc;
        if (n == -1 && bl) {
            n = 1;
        }
        return n;
    }

    public final float getWidth(int n) {
        float f = -1.0f;
        if (this.widthTable != null && n != -1) {
            f = this.widthTable[n];
        }
        if (f == -1.0f) {
            if (this.isCIDFont) {
                f = this.defaultWidth;
            } else {
                Float f2;
                String string = this.getMappedChar(n, false);
                if (string != null && string.equals(".notdef")) {
                    string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
                }
                f = (f2 = StandardFonts.getStandardWidth(this.glyphs.fontName, string)) != null ? f2.floatValue() : (this.missingWidth != -1.0f ? this.missingWidth * 0.001f : 0.0f);
            }
        }
        return f;
    }

    public void createCIDFont(PdfObject pdfObject, PdfObject pdfObject2) throws PdfFontException {
        PdfObject pdfObject3;
        Object object;
        PdfObject pdfObject4;
        int n;
        String string;
        PdfObject pdfObject5;
        this.cachedValue = new String[65536];
        PdfObject pdfObject6 = pdfObject.getDictionary(1232564598);
        if (pdfObject6 != null) {
            this.handleCIDEncoding(pdfObject6);
        }
        if ((pdfObject5 = pdfObject.getDictionary(1919185554)) != null) {
            this.readUnicode(this.currentPdfFile.readStream(pdfObject5, true, true, false, false, false), this.fontID);
        }
        if ((string = pdfObject2.getStringValue(39)) != null) {
            this.setCIDFontWidths(string);
        }
        if ((n = pdfObject2.getInt(5159)) >= 0) {
            this.defaultWidth = (float)n / 1000.0f;
        }
        if ((pdfObject4 = pdfObject2.getDictionary(946823533)) != null) {
            object = this.currentPdfFile.readStream(pdfObject4, true, true, false, false, false);
            if (object != null) {
                int n2 = 0;
                int n3 = ((byte[])object).length;
                int[] nArray = new int[n3 / 2];
                for (int i = 0; i < n3; i += 2) {
                    nArray[n2] = ((object[i] & 0xFF) << 8) + (object[i + 1] & 0xFF);
                    ++n2;
                }
                this.glyphs.setGIDtoCID(nArray);
            } else {
                this.handleCIDEncoding(new PdfFontObject(2038913669));
            }
        }
        object = null;
        PdfObject pdfObject7 = pdfObject2.getDictionary(1972801240);
        if (pdfObject7 != null) {
            object = pdfObject7.getTextStreamValue(1635480172);
        }
        if (object != null) {
            if (object.indexOf("Japan") != -1) {
                this.substituteFontFile = "kochi-mincho.ttf";
                this.substituteFontName = "Kochi Mincho";
                this.TTstreamisCID = false;
            } else if (object.indexOf("Korean") != -1) {
                System.err.println("Unsupported font encoding " + (String)object);
            } else if (object.indexOf("Chinese") != -1) {
                System.err.println("Chinese " + (String)object);
            }
            if (this.substituteFontName != null) {
                LogWriter.writeLog("Using font " + this.substituteFontName + " for " + (String)object);
            }
        }
        if (pdfObject2 != null && (pdfObject3 = pdfObject2.getDictionary(-1044665361)) != null) {
            this.setBoundsAndMatrix(pdfObject3);
            this.setName(pdfObject3, this.fontID);
        }
    }

    protected final void selectDefaultFont() {
    }

    public void readWidths(PdfObject pdfObject, boolean bl) throws Exception {
        LogWriter.writeMethod("{readWidths}", 0);
        float f = 0.0f;
        int n = 0;
        float[] fArray = pdfObject.getFloatArray(876896124);
        if (fArray != null) {
            int n2;
            this.widthTable = new float[this.maxCharCount];
            for (n2 = 0; n2 < this.maxCharCount; ++n2) {
                this.widthTable[n2] = -1.0f;
            }
            n2 = pdfObject.getInt(1283093660);
            int n3 = pdfObject.getInt(795440262);
            float f2 = (float)(1.0 / this.FontMatrix[0]);
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            int n4 = 0;
            int n5 = fArray.length;
            for (int i = n2; i < n3 + 1; ++i) {
                if (n4 < n5) {
                    float f3 = fArray[n4];
                    float f4 = this.fontTypes == 1228944679 ? f3 / f2 : f3 * 0.001f;
                    if (f4 > 0.0f) {
                        f += f4;
                        ++n;
                    }
                    this.widthTable[i] = f4;
                } else {
                    this.widthTable[i] = 0.0f;
                }
                ++n4;
            }
        }
        if (bl && n > 0) {
            this.possibleSpaceWidth = f / (float)(2 * n);
        }
    }

    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        LogWriter.writeMethod("{readNonCIDFont} render=" + bl, 0);
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setName(pdfObject, string);
        this.setEncoding(pdfObject, string, pdfObject2);
    }

    protected void setName(PdfObject pdfObject, String string) {
        String string2 = pdfObject.getStringValue(678461817);
        if (string2 == null) {
            string2 = pdfObject.getStringValue(879786873);
        }
        if (string2 == null) {
            string2 = this.fontID;
        }
        if (PdfStreamDecoder.runningStoryPad) {
            string2 = this.cleanupFontName(string2);
        }
        this.glyphs.setBaseFontName(string2);
        String string3 = pdfObject.getStringValue(678461817, 2);
        if (string3 == null) {
            string3 = pdfObject.getStringValue(879786873, 2);
        }
        if (string3 == null) {
            string3 = this.fontID;
        }
        if (PdfStreamDecoder.runningStoryPad) {
            string3 = this.cleanupFontName(string3);
        }
        this.glyphs.fontName = string3;
    }

    protected void setEncoding(PdfObject pdfObject, String string, PdfObject pdfObject2) {
        PdfObject pdfObject3;
        PdfObject pdfObject4 = pdfObject.getDictionary(1919185554);
        if (pdfObject4 != null) {
            this.readUnicode(this.currentPdfFile.readStream(pdfObject4, true, true, false, false, false), string);
        }
        if ((pdfObject3 = pdfObject.getDictionary(1232564598)) != null) {
            this.handleFontEncoding(pdfObject, pdfObject3);
        } else {
            this.handleNoEncoding(0, pdfObject);
        }
        if (pdfObject2 != null) {
            this.fontFlag = pdfObject2 == null ? 0 : pdfObject2.getInt(1009858393);
            this.glyphs.remapFont = false;
            int n = this.fontFlag;
            if ((n & 4) == 4) {
                this.glyphs.remapFont = true;
            }
            this.missingWidth = pdfObject2.getInt(-1884569950);
        }
    }

    protected void setBoundsAndMatrix(PdfObject pdfObject) {
        if (pdfObject != null) {
            float[] fArray;
            double[] dArray = pdfObject.getDoubleArray(-2105119560);
            if (dArray != null) {
                this.FontMatrix = dArray;
            }
            if ((fArray = pdfObject.getFloatArray(676429196)) != null) {
                this.FontBBox = fArray;
            }
        }
    }

    protected void init(String string, boolean bl) {
        if (bl && PdfJavaGlyphs.fontList == null) {
            PdfJavaGlyphs.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n = PdfJavaGlyphs.fontList.length;
            for (int i = 0; i < n; ++i) {
                PdfJavaGlyphs.fontList[i] = PdfJavaGlyphs.fontList[i].toLowerCase();
            }
        }
        this.fontID = string;
        this.renderPage = bl;
    }

    protected int handleNoEncoding(int n, PdfObject pdfObject) {
        int n2 = pdfObject.getGeneralType(1232564598);
        if (n2 == 5) {
            this.putFontEncoding(5);
            this.glyphs.defaultFont = "Zapf Dingbats";
            StandardFonts.checkLoaded(5);
            n = 5;
        } else if (n2 == 4) {
            this.putFontEncoding(4);
            n = 4;
        } else {
            this.putFontEncoding(1);
        }
        this.hasEncoding = false;
        return n;
    }

    protected final void handleFontEncoding(PdfObject pdfObject, PdfObject pdfObject2) {
        int n;
        int n2;
        PdfArrayIterator pdfArrayIterator;
        int n3 = pdfObject.getParameterConstant(1147962727);
        this.hasFontEncoding = true;
        int n4 = this.getFontEncoding(false);
        if (n4 == -1) {
            n4 = n3 == 1217103210 ? 0 : 1;
        }
        if ((pdfArrayIterator = pdfObject2.getArrayIterator(1954328750)) != null && pdfArrayIterator.getTokenCount() > 0) {
            this.glyphs.setIsSubsetted(true);
            n2 = 0;
            while (pdfArrayIterator.hasMoreTokens()) {
                n = pdfArrayIterator.getNextValueType();
                if (n == 1) {
                    n2 = pdfArrayIterator.getNextValueAsInteger();
                    continue;
                }
                this.putMappedChar(n2, pdfArrayIterator.getNextValueAsFontChar(n2));
                ++n2;
            }
            this.isHex = pdfArrayIterator.hasHexChars();
            int n5 = pdfArrayIterator.getSpaceChar();
            if (n5 != -1) {
                this.spaceChar = n5;
            }
        }
        n2 = -1;
        if (pdfObject2 != null) {
            this.hasEncoding = true;
            n = pdfObject2.getGeneralType(1232564598);
            if (n == -1) {
                n = pdfObject2.getParameterConstant(1537782955);
            }
            n2 = n != -1 ? n : this.handleNoEncoding(n4, pdfObject);
        }
        this.putFontEncoding(n2);
    }

    protected final void putMappedChar(int n, String string) {
        if (this.diffTable == null) {
            this.diffTable = new String[this.maxCharCount];
            this.diffLookup = new HashMap();
        }
        if (this.diffTable[n] == null) {
            this.diffTable[n] = string;
            this.diffLookup.put(string, new Integer(n));
        }
    }

    public double getType3Ydisplacement(int n) {
        return 0.0;
    }

    public final String getMappedChar(int n, boolean bl) {
        String string = null;
        if (this.diffTable != null) {
            string = this.diffTable[n];
        }
        if (bl && string != null && string.equals(".notdef")) {
            string = " ";
        }
        if (string == null && n < 335) {
            string = StandardFonts.getUnicodeChar(this.getFontEncoding(true), n);
        }
        if (string == null && n > 40 && this.getFontEncoding(true) == 2) {
            string = "bullet";
        }
        if (this.isFontEmbedded && string == null) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 335) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    public final String getEmbeddedChar(int n) {
        String string = null;
        if (this.isFontEmbedded) {
            if (this.diffs != null) {
                string = this.diffs[n];
            }
            if (string == null && n < 256) {
                string = StandardFonts.getUnicodeChar(this.embeddedEnc, n);
            }
        }
        return string;
    }

    protected final void readUnicode(byte[] byArray, String string) {
        if (byArray == null) {
            return;
        }
        this.unicodeMappings = new String[this.maxCharCount];
        int n = byArray.length;
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                if (i + 4 < n && byArray[i] == 101 && byArray[i + 1] == 110 && byArray[i + 2] == 100 && byArray[i + 3] == 98 && byArray[i + 4] == 102) {
                    n2 = 0;
                } else if (n2 > 0) {
                    int n3;
                    int n4;
                    int n5 = n2 + 1;
                    int[] nArray = new int[100];
                    boolean bl = false;
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (!bl) {
                            while (byArray[i] != 60) {
                                ++i;
                            }
                            ++i;
                        }
                        n3 = 0;
                        int n6 = 0;
                        while (byArray[i] != 62) {
                            if (byArray[i] != 10 && byArray[i] != 13 && byArray[i] != 32) {
                                ++n6;
                            }
                            ++i;
                            ++n3;
                            if (n6 != 5) continue;
                            --n3;
                            --i;
                            ++n5;
                            bl = true;
                            break;
                        }
                        int n7 = 0;
                        for (int j = 0; j < n3; ++j) {
                            int n8;
                            while ((n8 = byArray[i - 1 - j]) == 10 || n8 == 13 || n8 == 32) {
                                ++j;
                            }
                            if (n8 >= 65 && n8 <= 70) {
                                n8 -= 55;
                            } else if (n8 >= 97 && n8 <= 102) {
                                n8 -= 87;
                            } else if (n8 >= 48 && n8 <= 57) {
                                n8 -= 48;
                            } else {
                                throw new RuntimeException("Unexpected number " + (char)n8);
                            }
                            nArray[n4] = nArray[n4] + n8 * powers[n7];
                            ++n7;
                        }
                    }
                    while (byArray[i] == 62 || byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) {
                        ++i;
                    }
                    --i;
                    if (n2 == 1) {
                        if (n5 == 2) {
                            this.unicodeMappings[nArray[0]] = new String(String.valueOf((char)nArray[n2]));
                        } else {
                            char[] cArray = new char[n5 - 1];
                            for (n3 = 0; n3 < n5 - 1; ++n3) {
                                cArray[n3] = (char)nArray[n2 + n3];
                            }
                            this.unicodeMappings[nArray[0]] = new String(cArray);
                        }
                    } else {
                        for (n4 = nArray[0]; n4 < nArray[1] + 1; ++n4) {
                            this.unicodeMappings[n4] = new String(String.valueOf((char)(nArray[n2] + n4 - nArray[0])));
                        }
                    }
                }
                if (byArray[i] == 98 && byArray[i + 1] == 101 && byArray[i + 2] == 103 && byArray[i + 3] == 105 && byArray[i + 4] == 110 && byArray[i + 5] == 98 && byArray[i + 6] == 102 && byArray[i + 7] == 99 && byArray[i + 8] == 104 && byArray[i + 9] == 97 && byArray[i + 10] == 114) {
                    n2 = 1;
                    i += 10;
                    continue;
                }
                if (byArray[i] != 98 || byArray[i + 1] != 101 || byArray[i + 2] != 103 || byArray[i + 3] != 105 || byArray[i + 4] != 110 || byArray[i + 5] != 98 || byArray[i + 6] != 102 || byArray[i + 7] != 114 || byArray[i + 8] != 97 || byArray[i + 9] != 110 || byArray[i + 10] != 103 || byArray[i + 11] != 101) continue;
                n2 = 2;
                i += 11;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception setting up text object " + exception);
        }
    }

    public final int getFontType() {
        return this.fontTypes;
    }

    public String getSubstituteFont() {
        return this.substituteFontName;
    }

    public boolean isValidCodeRange(int n) {
        if (this.CMAP == null) {
            return false;
        }
        return this.CMAP[n] != null;
    }

    public float getGlyphWidth(String string, int n, String string2) {
        if (this.fontTypes == 1217103210) {
            return this.glyphs.getTTWidth(string, n, string2, false);
        }
        return 0.0f;
    }

    public void setSubtype(int n) {
        this.fontTypes = n;
    }

    public void setSubstituted(boolean bl) {
        this.isFontSubstituted = bl;
    }

    public PdfJavaGlyphs getGlyphData() {
        return this.glyphs;
    }

    public Font setFont(String string, int n) {
        return this.glyphs.setFont(string, n);
    }

    public boolean is1C() {
        return this.glyphs.is1C();
    }

    public boolean isFontSubsetted() {
        return this.glyphs.isSubsetted;
    }

    public void setValuesForGlyph(int n, String string, String string2, String string3) {
        this.glyphs.setValuesForGlyph(n, string, string2, string3);
    }

    String cleanupFontName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '-') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public Rectangle getBoundingBox() {
        float[] fArray = StandardFonts.getFontBounds(this.getFontName());
        if (fArray == null) {
            if (!this.isFontEmbedded) {
                return new Rectangle(0, 0, 1000, 1000);
            }
            return new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1]));
        }
        return new Rectangle((int)fArray[0], (int)fArray[1], (int)(fArray[2] - fArray[0]), (int)(fArray[3] - fArray[1]));
    }

    static {
        PdfFont.setStandardFontMappings();
    }
}

