/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPageObject;
import org.jpedal.render.DynamicVectorRenderer;

public final class MultiDisplay
extends SingleDisplay
implements Display {
    private Thread worker = null;
    private Object customSwingHandle = null;
    private int pageUsedForTransform;

    public MultiDisplay(int pageNumber, int pageCount, DynamicVectorRenderer currentDisplay, int displayView, Object gui) {
        super(pageNumber, pageCount, currentDisplay);
        this.customSwingHandle = gui;
        this.displayView = displayView;
        if (currentDisplay != null) {
            this.currentPageViews.put(new Integer(pageNumber), currentDisplay);
        }
    }

    public final void decodeOtherPages(int pageNumber, int pageCount) {
        this.pageNumber = pageNumber;
        if (!this.isInitialised) {
            return;
        }
        this.setPageOffsets(pageCount, this.pageNumber);
        this.calcDisplayedRange();
        if (this.worker == null || !this.running) {
            this.running = true;
            while (this.thumbnailsRunning) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.worker = new Thread(){

                public void run() {
                    try {
                        MultiDisplay.this.decodeOtherPages();
                        MultiDisplay.this.running = false;
                    }
                    catch (Exception e) {
                        MultiDisplay.this.running = false;
                    }
                    catch (Error err) {
                        MultiDisplay.this.running = false;
                    }
                }
            };
            this.worker.start();
        }
    }

    private void decodeOtherPages() {
        this.isGeneratingOtherPages = true;
        int page = this.startViewPage;
        int originalStart = this.startViewPage;
        int originalEnd = this.endViewPage + 1;
        this.resetPageCaches(this.startViewPage, this.endViewPage + 1);
        while (this.isGeneratingOtherPages) {
            String currentPageOffset;
            if (originalStart != this.startViewPage && originalEnd != this.endViewPage) {
                page = this.startViewPage;
                originalEnd = this.endViewPage + 1;
                if (page == 0) {
                    // empty if block
                }
                originalStart = ++page;
                this.resetPageCaches(originalStart, originalEnd);
            }
            if (page == originalEnd) break;
            if (this.currentPageViews.get(new Integer(page)) == null && (currentPageOffset = (String)this.pdf.pagesReferences.get(new Integer(page))) != null) {
                PdfPageObject pdfObject = new PdfPageObject(currentPageOffset);
                this.pdf.readObjectForPage((PdfObject)pdfObject, currentPageOffset, page, true);
                PdfObject Resources = pdfObject.getDictionary(2004251818);
                Integer key = new Integer(page);
                Object currentView = this.currentPageViews.get(key);
                if (currentView == null && this.isGeneratingOtherPages) {
                    DynamicVectorRenderer currentDisplay = null;
                    currentDisplay = ObjectStore.getCachedPage((Integer)key);
                    if (currentDisplay != null) {
                        currentDisplay.setObjectStoreRef(this.pdf.objectStoreRef);
                        this.currentPageViews.put(new Integer(page), currentDisplay);
                    } else {
                        currentDisplay = new DynamicVectorRenderer(page, this.pdf.objectStoreRef, false);
                        if (this.isGeneratingOtherPages) {
                            this.getPageView(Resources, (PdfObject)pdfObject, currentDisplay, page);
                        }
                        this.currentPageViews.put(new Integer(page), currentDisplay);
                        ObjectStore.cachePage((Integer)key, (DynamicVectorRenderer)currentDisplay);
                    }
                    if (this.thumbnails != null && this.thumbnails.isShownOnscreen()) {
                        this.thumbnails.addDisplayedPageAsThumbnail(page, currentDisplay);
                    }
                }
                Runnable getTextFieldText = new Runnable(){

                    public void run() {
                        MultiDisplay.this.pdf.repaint();
                    }
                };
                SwingUtilities.invokeLater(getTextFieldText);
            }
            ++page;
        }
        Runnable getTextFieldText = new Runnable(){

            public void run() {
                if (MultiDisplay.this.thumbnails != null && MultiDisplay.this.thumbnails.isShownOnscreen()) {
                    MultiDisplay.this.thumbnails.generateOtherVisibleThumbnails(MultiDisplay.this.pdf.pageNumber);
                }
            }
        };
        SwingUtilities.invokeLater(getTextFieldText);
    }

    public final void initRenderer(Rectangle[] areas, Graphics2D g2, Border myBorder, int indent) {
        this.myBorder = myBorder;
        this.rawAf = g2.getTransform();
        this.rawClip = g2.getClip();
        this.areas = null;
        this.g2 = g2;
        this.indent = indent;
        this.pagesDrawn.clear();
        this.setPageOffsets(this.pageCount, this.pageNumber);
        this.calcDisplayedRange();
        this.setPageSize(this.pageUsedForTransform, this.scaling);
    }

    private void resetPageCaches(int startPage, int endPage) {
        Iterator keys = this.cachedPageViews.keySet().iterator();
        while (keys.hasNext()) {
            Object obj;
            Integer currentKey = (Integer)keys.next();
            int keyValue = currentKey;
            if (keyValue < startPage || keyValue > endPage || (obj = this.cachedPageViews.get(currentKey)) == null) continue;
            this.currentPageViews.put(currentKey, obj);
        }
        keys = this.currentPageViews.keySet().iterator();
        HashMap<Integer, String> keysToTrash = new HashMap<Integer, String>();
        while (keys.hasNext()) {
            Integer currentKey = (Integer)keys.next();
            int keyValue = currentKey;
            if (keyValue >= startPage && keyValue <= endPage) continue;
            Object obj = this.currentPageViews.get(currentKey);
            if (obj != null) {
                this.cachedPageViews.put(currentKey, obj);
            }
            keysToTrash.put(currentKey, "x");
        }
        keys = keysToTrash.keySet().iterator();
        while (keys.hasNext()) {
            this.currentPageViews.remove(keys.next());
        }
    }

    private synchronized void calcDisplayedRange() {
        if (this.displayView == 1) {
            return;
        }
        this.getDisplayedRectangle();
        if (this.displayView == 3) {
            if (this.pageCount == 2) {
                this.startViewPage = 1;
                this.endViewPage = 2;
            } else {
                this.startViewPage = this.pageNumber;
                if (this.startViewPage == 1) {
                    this.endViewPage = 1;
                } else if ((this.startViewPage & 1) != 1) {
                    this.startViewPage = this.pageNumber;
                    this.endViewPage = this.pageNumber + 1;
                } else {
                    this.startViewPage = this.pageNumber - 1;
                    this.endViewPage = this.pageNumber;
                }
            }
        } else {
            boolean yOverlap;
            boolean xOverlap;
            int newPage;
            this.pdf.pageNumber = newPage = this.updatePageDisplayed();
            if (newPage != -1 && this.customSwingHandle != null) {
                ((GUIFactory)this.customSwingHandle).setPage(newPage);
            }
            int i = 1;
            while (i < this.pageCount + 1) {
                xOverlap = this.rx < this.xReached[i] + this.pageW[i] && this.rw > this.xReached[i];
                boolean bl = yOverlap = this.ry < this.yReached[i] + this.pageH[i] && this.rh + this.ry > this.yReached[i];
                if (xOverlap && yOverlap) {
                    this.startViewPage = i;
                    i = this.pageCount;
                }
                ++i;
            }
            this.endViewPage = this.pageCount;
            i = this.startViewPage;
            while (i < this.pageCount + 1) {
                xOverlap = this.rx < this.xReached[i] + this.pageW[i] && this.rw > this.xReached[i];
                boolean bl = yOverlap = this.ry < this.yReached[i] + this.pageH[i] && this.rh + this.ry + this.insetH + 10 > this.yReached[i];
                if (!(this.displayView != 4 && this.displayView != 2 && xOverlap || yOverlap)) {
                    this.endViewPage = i - 1;
                    i = this.pageCount;
                }
                ++i;
            }
        }
        if (this.displayView != 3 && this.startViewPage > 1) {
            --this.startViewPage;
        }
    }

    private int updatePageDisplayed() {
        int newPage;
        block17: {
            block18: {
                newPage = -1;
                if (this.displayView != 2) break block18;
                int i = 1;
                while (i < this.pageCount) {
                    if (this.yReached[i] + this.insetH - this.ry + this.pageH[i] >= 0) {
                        if (this.ry > this.yReached[i] + this.insetH) {
                            int visibleAmountOfPage1 = this.yReached[i] + this.insetH - this.ry + this.pageH[i] / 2;
                            int visibleAmountOfPage2 = this.ry - this.yReached[i + 1];
                            if (visibleAmountOfPage2 > this.pageH[i + 1]) {
                                visibleAmountOfPage2 = this.pageH[i + 1];
                            }
                            newPage = visibleAmountOfPage1 >= visibleAmountOfPage2 && visibleAmountOfPage1 != 1 ? i : i + 1;
                        } else {
                            newPage = i;
                        }
                        break block17;
                    }
                    ++i;
                }
                break block17;
            }
            if (this.displayView != 4) break block17;
            if (this.yReached[1] + this.insetH - this.ry + this.pageH[1] >= 0) {
                if (this.pageCount > 1) {
                    if (this.ry > this.yReached[1] + this.insetH) {
                        int visibleAmountOfPage1 = this.yReached[1] + this.insetH - this.ry + this.pageH[1];
                        int visibleAmountOfPage2 = this.rh - this.yReached[2];
                        if (visibleAmountOfPage2 > this.pageH[1]) {
                            visibleAmountOfPage2 = this.pageH[1];
                        }
                        newPage = visibleAmountOfPage1 >= visibleAmountOfPage2 ? 1 : 2;
                    } else {
                        newPage = 1;
                    }
                } else {
                    newPage = 1;
                }
            } else {
                int i = 2;
                while (i < this.pageCount) {
                    if (this.yReached[i] + this.insetH - this.ry + this.pageH[i] >= 0) {
                        if (this.ry > this.yReached[i]) {
                            int visibleAmountOfPage1 = this.yReached[i] + this.insetH - this.ry + this.pageH[i];
                            int visibleAmountOfPage2 = i + 2 >= this.pageCount ? 0 : this.rh - this.yReached[i + 2];
                            if (visibleAmountOfPage2 > this.pageH[i]) {
                                visibleAmountOfPage2 = this.pageH[i];
                            }
                            newPage = visibleAmountOfPage1 >= visibleAmountOfPage2 ? i : i + 2;
                        } else {
                            newPage = i;
                        }
                        break;
                    }
                    i += 2;
                }
            }
        }
        return newPage;
    }

    private void drawOtherPages(AffineTransform original, AffineTransform viewScaling, Graphics2D g2, Rectangle userAnnot, float scaling, boolean isAccelerated) {
        int startPage = 1;
        int endPage = this.pageCount;
        startPage = this.startViewPage;
        endPage = this.endViewPage;
        if (startPage > endPage) {
            return;
        }
        if (this.displayView != 2 && this.pageCount == 2) {
            ++endPage;
        }
        AffineTransform old = g2.getTransform();
        Shape oldClip = g2.getClip();
        int i = startPage;
        while (i < endPage + 1) {
            if (i > this.pageCount) break;
            int displayRotation = this.pageData.getRotation(i);
            if (!isAccelerated || this.accleratedPagesAlreadyDrawn.get(new Integer(i)) == null) {
                DynamicVectorRenderer otherPage = (DynamicVectorRenderer)this.currentPageViews.get(new Integer(i));
                int dx = this.pageData.getScaledCropBoxX(i);
                int dy = this.pageData.getScaledCropBoxY(i);
                double cropX = dx;
                double cropY = dy;
                double cropH = this.pageData.getCropBoxHeight(i);
                if (otherPage != null) {
                    int tmp;
                    double y;
                    g2.setTransform(original);
                    if (!isAccelerated) {
                        g2.setClip(this.pdf.getVisibleRect());
                    }
                    g2.setTransform(old);
                    int crx = (int)((float)this.xReached[i] / scaling);
                    int cry = (int)((float)this.yReached[i] / scaling);
                    g2.translate(crx - dx, -dy - cry);
                    int diff = 0;
                    int diffY = 0;
                    if (this.displayView == 2) {
                        diff = displayRotation == 0 || displayRotation == 180 ? (int)(((float)this.currentOffset.widestPageNR - (float)this.pageW[i] / scaling) / 2.0f) : (int)(((float)this.currentOffset.widestPageR - (float)this.pageW[i] / scaling) / 2.0f);
                    }
                    if (displayRotation == this.pageData.getRotation(this.pageUsedForTransform)) {
                        if (this.displayRotation == 0 || this.displayRotation == 180) {
                            g2.translate(0.0, (float)(this.pageH[this.pageUsedForTransform] - this.pageH[i]) / scaling);
                        } else {
                            g2.translate(0.0, (float)(-(this.pageH[this.pageUsedForTransform] - this.pageH[i])) / scaling);
                        }
                    }
                    if ((displayRotation += this.displayRotation) >= 360) {
                        displayRotation -= 360;
                    }
                    if (displayRotation == 180) {
                        AffineTransform aff = g2.getTransform();
                        double x = aff.getTranslateX() / (double)scaling;
                        y = aff.getTranslateY() / (double)scaling;
                        g2.translate(-x, -y);
                        g2.rotate(Math.PI);
                        g2.translate(-x - (double)((float)this.pageW[i] / scaling) - (double)diff, (double)(-((float)this.pageH[i] / scaling)) - y);
                        g2.translate(-(2 * dx), -(2 * dy));
                    } else if (displayRotation == 270) {
                        AffineTransform aff = g2.getTransform();
                        double x = aff.getTranslateX() / (double)scaling;
                        y = aff.getTranslateY() / (double)scaling;
                        g2.translate(-x, y);
                        g2.rotate(1.5707963267948966);
                        g2.translate(-y, -x - (double)((float)this.pageW[i] / scaling));
                        int diff2 = (int)((float)(this.pageW[i] - this.pageH[i]) / (scaling * 2.0f));
                        g2.translate(diff2 * 2 + diffY, diff);
                        g2.translate(0, -(2 * dx));
                        int dy2 = this.pageData.getScaledCropBoxY(this.pageUsedForTransform);
                        g2.translate(0, -(2 * dy2));
                    } else if (displayRotation == 90) {
                        AffineTransform aff = g2.getTransform();
                        double x = aff.getTranslateX() / (double)scaling;
                        y = aff.getTranslateY() / (double)scaling;
                        g2.translate(-x, y);
                        g2.rotate(-1.5707963267948966);
                        g2.translate(y - (double)((float)this.pageW[i] / scaling), x);
                        g2.translate(diffY, diff);
                        g2.translate(-(2 * dy), 0);
                    } else {
                        g2.translate(diff, diffY);
                    }
                    otherPage.setScalingValues(cropX, cropH + cropY, scaling);
                    int dw = (int)((float)this.pageW[i] / scaling);
                    int dh = (int)((float)this.pageH[i] / scaling);
                    if (displayRotation == 90 || displayRotation == 270) {
                        tmp = dw;
                        dw = dh;
                        dh = tmp;
                    }
                    if (displayRotation == 90 || displayRotation == 270) {
                        tmp = dx;
                        dx = dy;
                        dy = tmp;
                    }
                    g2.clip(new Rectangle(dx, dy, dw, dh));
                    otherPage.paint(g2, this.areas, viewScaling, userAnnot, false, true);
                    this.pagesDrawn.put(new Integer(i), "x");
                    if (isAccelerated) {
                        this.accleratedPagesAlreadyDrawn.put(new Integer(i), "x");
                    }
                    g2.setTransform(old);
                    g2.setClip(oldClip);
                }
            }
            ++i;
        }
    }

    public final void drawBorder() {
        int startPage = this.startViewPage;
        int endPage = this.endViewPage;
        if (startPage == 0) {
            return;
        }
        if (this.displayView == 2 || this.displayView == 4) {
            startPage = 1;
            endPage = this.pageCount;
        }
        if (this.rawAf != null) {
            this.g2.setTransform(this.rawAf);
        }
        this.g2.setClip(this.rawClip);
        if (this.displayView != 3 && startPage > 1) {
            --startPage;
            if (this.pageCount == 2) {
                ++endPage;
            }
        }
        int displacementPage = 1;
        if (this.displayView != 2 && displacementPage & true) {
            --displacementPage;
        }
        this.g2.translate(-this.xReached[displacementPage] + this.insetW, -this.yReached[displacementPage] + this.insetH);
        int i = startPage;
        while (i < endPage + 1) {
            if (i == this.xReached.length) break;
            AffineTransform aff = null;
            if (this.displayView == 2) {
                aff = this.g2.getTransform();
                int diff = 0;
                diff = this.displayRotation == 0 || this.displayRotation == 180 ? (int)(((float)this.currentOffset.widestPageNR * this.scaling - (float)this.pageW[i]) / 2.0f) : (int)(((float)this.currentOffset.widestPageR * this.scaling - (float)this.pageW[i]) / 2.0f);
                this.g2.translate(diff, 0);
            } else if ((this.displayView == 4 || this.displayView == 3) && this.pageCount > 1) {
                aff = this.g2.getTransform();
            }
            if (this.pagesDrawn.get(new Integer(i)) == null && this.accleratedPagesAlreadyDrawn.get(new Integer(i)) == null) {
                try {
                    this.g2.setColor(Color.white);
                    this.g2.fillRect(this.xReached[i], this.yReached[i], this.pageW[i], this.pageH[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.accleratedPagesAlreadyDrawn.get(new Integer(i)) == null) {
                // empty if block
            }
            if (PdfDecoder.CURRENT_BORDER_STYLE == 1 && this.pageW[i] > 0 && this.pageH[i] > 0 && this.myBorder != null) {
                this.myBorder.paintBorder(this.pdf, this.g2, this.xReached[i] - 1, this.yReached[i] - 1, this.pageW[i] + 2, this.pageH[i] + 2);
            }
            if (aff != null) {
                this.g2.setTransform(aff);
            }
            ++i;
        }
    }

    public final Rectangle drawPage(AffineTransform viewScaling, AffineTransform displayScaling, int pageUsedForTransform) {
        if (displayScaling != null) {
            if ((float)this.displayRotation != this.oldRotation) {
                this.setPageOffsets(this.pageCount, this.pageNumber);
                this.useAcceleration = true;
            }
            this.pageUsedForTransform = pageUsedForTransform;
            Rectangle userAnnot = null;
            if (!this.isAccelerated()) {
                this.calcVisibleArea(this.topH, this.topW);
            }
            this.g2.transform(displayScaling);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            boolean canDrawAccelerated = false;
            if (this.useAcceleration && !this.overRideAcceleration && this.scaling < 2.0f) {
                canDrawAccelerated = this.testAcceleratedRendering();
            }
            if (canDrawAccelerated) {
                Graphics2D gBB = (Graphics2D)this.backBuffer.getGraphics();
                if (this.screenNeedsRedrawing) {
                    gBB.setColor(this.pdf.getBackground());
                    gBB.fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                    this.screenNeedsRedrawing = false;
                }
                if (this.isInitialised && this.xReached != null) {
                    gBB.setTransform(displayScaling);
                    this.setDisplacementOnG2(gBB);
                    this.drawOtherPages(this.rawAf, viewScaling, gBB, userAnnot, this.scaling, true);
                }
                gBB.dispose();
                if (this.backBuffer != null) {
                    AffineTransform affBefore = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.setClip(this.rawClip);
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affBefore);
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                this.accleratedPagesAlreadyDrawn.clear();
                this.currentDisplay.setOptimsePainting(false);
                this.drawOtherPages(this.rawAf, viewScaling, this.g2, userAnnot, this.scaling, false);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
        return null;
    }
}

