/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import res.Config;

public class SwingSearchWindow
extends JFrame
implements GUISearchWindow {
    private boolean isSetup = false;
    String defaultMessage = "Enter your text here";
    JTextField searchText = null;
    JCheckBox searchAll;
    JTextField searchCount;
    DefaultListModel listModel;
    SearchList results;
    MouseListener ML;
    ActionListener AL = null;
    WindowListener WL;
    KeyListener KL;
    SwingWorker searcher = null;
    public boolean isSearch = false;
    JButton searchButton = null;
    private int itemFoundCount = 0;
    Map textPages = new HashMap();
    Map textRectangles = new HashMap();
    final JPanel nav = new JPanel();
    Values commonValues;
    SwingGUI currentGUI;
    PdfDecoder decode_pdf;
    private Config CONFIG;
    private boolean deleteOnClick;
    private boolean wasMaximised = false;
    private Dimension windowSize;

    public SwingSearchWindow(Values commonValues, SwingGUI currentGUI, PdfDecoder decode_pdf, Config conf) {
        this.commonValues = commonValues;
        this.currentGUI = currentGUI;
        this.decode_pdf = decode_pdf;
        this.CONFIG = conf;
    }

    public void find() {
        if (this.isSetup) {
            this.searchCount.setText(String.valueOf(this.CONFIG.getText("SearchBox_searchCount")) + " " + this.itemFoundCount);
            this.searchText.selectAll();
            this.searchText.grabFocus();
        } else {
            this.isSetup = true;
            this.defaultMessage = this.CONFIG.getText("SearchBox_defaultMessage");
            this.searchText = new JTextField(this.defaultMessage);
            this.searchButton = new JButton(this.CONFIG.getText("SearchBox_searchButton"));
            this.nav.setLayout(new BorderLayout());
            this.WL = new WindowListener(){

                public void windowOpened(WindowEvent arg0) {
                }

                public void windowClosing(WindowEvent arg0) {
                    SwingSearchWindow.this.removeSearchWindow(true);
                }

                public void windowClosed(WindowEvent arg0) {
                }

                public void windowIconified(WindowEvent arg0) {
                }

                public void windowDeiconified(WindowEvent arg0) {
                }

                public void windowActivated(WindowEvent arg0) {
                }

                public void windowDeactivated(WindowEvent arg0) {
                }
            };
            this.addWindowListener(this.WL);
            this.nav.add((Component)this.searchButton, "East");
            this.nav.add((Component)this.searchText, "Center");
            this.searchAll = new JCheckBox();
            this.searchAll.setSelected(true);
            this.searchAll.setText(this.CONFIG.getText("SearchBox_searchAll"));
            this.nav.add((Component)this.searchAll, "North");
            this.itemFoundCount = 0;
            this.textPages.clear();
            this.textRectangles.clear();
            this.listModel = null;
            this.searchCount = new JTextField(String.valueOf(this.CONFIG.getText("SearchBox_searchCount")) + " " + this.itemFoundCount);
            this.searchCount.setEditable(false);
            this.nav.add((Component)this.searchCount, "South");
            this.listModel = new DefaultListModel();
            this.results = new SearchList(this.listModel, this.textPages);
            this.results.setSelectionMode(1);
            this.ML = new MouseListener(){

                public void mouseClicked(MouseEvent arg0) {
                    if (!SwingSearchWindow.this.commonValues.isProcessing()) {
                        Integer key;
                        Object newPage;
                        float scaling = SwingSearchWindow.this.currentGUI.getScaling();
                        int inset = SwingSearchWindow.this.currentGUI.getPDFDisplayInset();
                        int id = SwingSearchWindow.this.results.getSelectedIndex();
                        SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                        if (id != -1 && (newPage = SwingSearchWindow.this.textPages.get(key = new Integer(id))) != null) {
                            SwingSearchWindow.this.decode_pdf.setDisplayView(1, 2);
                            int nextPage = (Integer)newPage;
                            Rectangle highlight = (Rectangle)SwingSearchWindow.this.textRectangles.get(key);
                            if (SwingSearchWindow.this.commonValues.getCurrentPage() != nextPage) {
                                SwingSearchWindow.this.commonValues.setCurrentPage(nextPage);
                                SwingSearchWindow.this.decode_pdf.setPageParameters(scaling, SwingSearchWindow.this.commonValues.getCurrentPage());
                                SwingSearchWindow.this.currentGUI.decodePage(false);
                                SwingSearchWindow.this.decode_pdf.invalidate();
                            }
                            int scrollInterval = SwingSearchWindow.this.decode_pdf.getScrollInterval();
                            int x = (int)((float)(highlight.x - SwingSearchWindow.this.currentGUI.cropX) * scaling) + inset;
                            int y = (int)((float)(SwingSearchWindow.this.currentGUI.cropH - (highlight.y - SwingSearchWindow.this.currentGUI.cropY)) * scaling) + inset;
                            int w = (int)((float)highlight.width * scaling);
                            int h = (int)((float)highlight.height * scaling);
                            Rectangle scrollto = new Rectangle(x - scrollInterval, y - h - scrollInterval, w + scrollInterval * 2, h + scrollInterval * 2);
                            SwingSearchWindow.this.decode_pdf.scrollRectToVisible(scrollto);
                            SwingSearchWindow.this.decode_pdf.setFoundTextArea(highlight);
                            SwingSearchWindow.this.decode_pdf.invalidate();
                            SwingSearchWindow.this.decode_pdf.repaint();
                        }
                    }
                }

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseEntered(MouseEvent arg0) {
                }

                public void mouseExited(MouseEvent arg0) {
                }
            };
            this.results.addMouseListener(this.ML);
            this.AL = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!SwingSearchWindow.this.isSearch) {
                        try {
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception e1) {
                            System.out.println("Exception " + e1);
                            e1.printStackTrace();
                        }
                    } else {
                        SwingSearchWindow.this.searcher.interrupt();
                        SwingSearchWindow.this.isSearch = false;
                        SwingSearchWindow.this.searchButton.setText(SwingSearchWindow.this.CONFIG.getText("SearchBox_searchButton"));
                    }
                }
            };
            this.searchButton.addActionListener(this.AL);
            this.searchText.selectAll();
            this.deleteOnClick = true;
            this.KL = new KeyListener(){

                public void keyTyped(KeyEvent e) {
                    char key;
                    int id;
                    if (SwingSearchWindow.this.deleteOnClick) {
                        SwingSearchWindow.this.deleteOnClick = false;
                        SwingSearchWindow.this.searchText.setText("");
                    }
                    if ((id = e.getID()) == 400 && (key = e.getKeyChar()) == '\n') {
                        try {
                            SwingSearchWindow.this.searchText();
                        }
                        catch (Exception e1) {
                            System.out.println("Exception " + e1);
                            e1.printStackTrace();
                        }
                    }
                }

                public void keyPressed(KeyEvent arg0) {
                }

                public void keyReleased(KeyEvent arg0) {
                }
            };
            this.searchText.addKeyListener(this.KL);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(this.results);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.getVerticalScrollBar().setUnitIncrement(80);
            scrollPane.getHorizontalScrollBar().setUnitIncrement(80);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)scrollPane, "Center");
            this.getContentPane().add((Component)this.nav, "North");
        }
        if (this.currentGUI.getMyFrame().getExtendedState() == 6) {
            this.wasMaximised = true;
        } else {
            this.wasMaximised = false;
            this.windowSize = this.currentGUI.getMyFrame().size();
        }
        Container frame = this.commonValues.getModeOfOperation() == 1 ? this.currentGUI.getMyFrame().getContentPane() : this.currentGUI.getMyFrame();
        int w = 230;
        int h = frame.getHeight();
        int x1 = frame.getLocationOnScreen().x;
        int x = frame.getWidth() + x1;
        int y = frame.getLocationOnScreen().y;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = d.width;
        if (x + w > width) {
            x = width - w;
            frame.setSize(x - x1, frame.getHeight());
        }
        this.setSize(w, h);
        this.setLocation(x, y);
        this.searchAll.setFocusable(false);
        this.searchText.grabFocus();
        this.show();
    }

    public void removeSearchWindow(boolean justHide) {
        this.hide();
        this.setVisible(false);
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        if (this.isSetup && !justHide) {
            if (this.listModel != null) {
                this.listModel.clear();
            }
            this.itemFoundCount = 0;
            this.isSearch = false;
        }
        if (this.wasMaximised) {
            this.currentGUI.getMyFrame().setExtendedState(6);
        } else if (this.windowSize != null) {
            this.currentGUI.getMyFrame().setSize(this.windowSize);
        }
    }

    private void searchText() throws Exception {
        if (this.searcher != null) {
            this.searcher.interrupt();
        }
        this.searchButton.setText(this.CONFIG.getText("SearchBox_searchButtonStop"));
        this.searchButton.invalidate();
        this.searchButton.repaint();
        this.isSearch = true;
        this.searchCount.setText(this.CONFIG.getText("SearchBox_searching"));
        this.searchCount.repaint();
        this.searcher = new SwingWorker(){

            public Object construct() {
                try {
                    SwingSearchWindow.this.listModel.removeAllElements();
                    SwingSearchWindow.this.results.repaint();
                    int listCount = 0;
                    SwingSearchWindow.this.textPages.clear();
                    SwingSearchWindow.this.textRectangles.clear();
                    SwingSearchWindow.this.itemFoundCount = 0;
                    SwingSearchWindow.this.decode_pdf.setFoundTextAreas(null);
                    String textToFind = SwingSearchWindow.this.searchText.getText();
                    PdfPageData pageSize = SwingSearchWindow.this.decode_pdf.getPdfPageData();
                    int startPage = 1;
                    int endPage = SwingSearchWindow.this.commonValues.getPageCount() + 1;
                    if (!SwingSearchWindow.this.searchAll.isSelected()) {
                        startPage = SwingSearchWindow.this.commonValues.getCurrentPage();
                        endPage = startPage + 1;
                    }
                    int i = startPage;
                    while (i < endPage) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        PdfGroupingAlgorithms currentGrouping = null;
                        try {
                            if (i == SwingSearchWindow.this.commonValues.getCurrentPage()) {
                                currentGrouping = SwingSearchWindow.this.decode_pdf.getGroupingObject();
                            } else {
                                SwingSearchWindow.this.decode_pdf.decodePageInBackground(i);
                                currentGrouping = SwingSearchWindow.this.decode_pdf.getBackgroundGroupingObject();
                            }
                            currentGrouping.generateTeasers();
                            int x1 = pageSize.getMediaBoxX(i);
                            int x2 = pageSize.getMediaBoxWidth(i);
                            int y1 = pageSize.getMediaBoxY(i);
                            int y2 = pageSize.getMediaBoxHeight(i);
                            float[] co_ords = currentGrouping.findTextInRectangle(x1, y2, x2 + x1, y1, i, textToFind, 0);
                            float[] endPoints = currentGrouping.getEndPoints();
                            String[] teasers = currentGrouping.getTeasers();
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (co_ords != null && teasers != null) {
                                SwingSearchWindow swingSearchWindow = SwingSearchWindow.this;
                                swingSearchWindow.itemFoundCount = swingSearchWindow.itemFoundCount + teasers.length;
                                int count = co_ords.length;
                                int next = 0;
                                int ii = 0;
                                while (ii < count) {
                                    int wx1 = (int)co_ords[ii];
                                    int wy1 = (int)co_ords[ii + 1];
                                    int wx2 = (int)endPoints[ii];
                                    int wy2 = (int)endPoints[ii + 1];
                                    String tease = teasers[ii / 2];
                                    int page = i;
                                    Runnable setTextRun = new Runnable(this, page, tease){
                                        final /* synthetic */ 5 this$1;
                                        private final /* synthetic */ int val$page;
                                        private final /* synthetic */ String val$tease;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$page = n;
                                            this.val$tease = string;
                                        }

                                        public void run() {
                                            5.access$0(this.this$1).listModel.addElement(String.valueOf(Messages.getMessage((String)"PdfViewerSearch.Page")) + " " + this.val$page + ": " + this.val$tease);
                                        }
                                    };
                                    SwingUtilities.invokeAndWait(setTextRun);
                                    Integer key = new Integer(listCount);
                                    ++listCount;
                                    SwingSearchWindow.this.textRectangles.put(key, new Rectangle(wx1, wy2, wx2 - wx1, wy1 - wy2));
                                    SwingSearchWindow.this.textPages.put(key, new Integer(i));
                                    ++next;
                                    ii += 2;
                                }
                            }
                            if (co_ords != null | i % 16 == 0) {
                                SwingSearchWindow.this.searchCount.setText(String.valueOf(SwingSearchWindow.this.CONFIG.getText("SearchBox_searchCount")) + " " + SwingSearchWindow.this.itemFoundCount + " " + SwingSearchWindow.this.CONFIG.getText("SearchBox_searching") + " " + i);
                                SwingSearchWindow.this.searchCount.invalidate();
                                SwingSearchWindow.this.searchCount.repaint();
                            }
                        }
                        catch (PdfException pdfException) {
                            // empty catch block
                        }
                        ++i;
                    }
                    SwingSearchWindow.this.searchCount.setText(String.valueOf(SwingSearchWindow.this.CONFIG.getText("SearchBox_searchCount")) + " " + SwingSearchWindow.this.itemFoundCount + "  " + SwingSearchWindow.this.CONFIG.getText("SearchBox_done"));
                    SwingSearchWindow.this.results.invalidate();
                    SwingSearchWindow.this.results.repaint();
                    SwingSearchWindow.this.isSearch = false;
                    SwingSearchWindow.this.searchButton.setText(SwingSearchWindow.this.CONFIG.getText("SearchBox_searchButton"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }

            static /* synthetic */ SwingSearchWindow access$0(5 var0) {
                return var0.SwingSearchWindow.this;
            }
        };
        this.searcher.start();
    }

    public void grabFocusInInput() {
        this.searchText.grabFocus();
    }

    public boolean isSearchVisible() {
        return this.isVisible();
    }
}

