/*
 * Decompiled with CFR 0.152.
 */
package gui.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import res.Config;
import res.LicFile;
import res.Lizenz_Client;
import res.Lizenz_Vertrag;
import res.Produkt;

public class InfoBox
extends JDialog {
    private LicFile LICFILE;
    private Config CONFIG;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JButton btn_close = null;
    private JTextPane edt_text = null;
    private JTabbedPane pnl_content = null;
    private String info = "";
    private boolean infoshow = true;

    public InfoBox(Config conf) {
        super(conf.getMasterFrame());
        this.CONFIG = conf;
        this.LICFILE = this.CONFIG.getLICFILE();
        this.initialize();
    }

    private void initialize() {
        Point pos = this.getOwner().getLocationOnScreen();
        this.setBounds(new Rectangle(pos.x + 80, pos.y + 50, 500, 400));
        this.setTitle(this.CONFIG.getText("InfoBox_Title"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getBtn_close(), "South");
            this.jContentPane.add((Component)this.getPnl_content(), "Center");
        }
        return this.jContentPane;
    }

    private JButton getBtn_close() {
        if (this.btn_close == null) {
            this.btn_close = new JButton();
            this.btn_close.setPreferredSize(new Dimension(34, 25));
            this.btn_close.setText(this.CONFIG.getText("InfoBox_btn_close"));
            this.btn_close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InfoBox.this.dispose();
                }
            });
        }
        return this.btn_close;
    }

    private JTextPane getEdt_text() {
        if (this.edt_text == null) {
            this.edt_text = new JTextPane();
            this.edt_text.setSize(150, 150);
            this.edt_text.setEditable(false);
            this.info = this.LICFILE.getInfo();
            this.edt_text.setText(this.info);
            this.edt_text.select(0, 0);
        }
        return this.edt_text;
    }

    private JTabbedPane getPnl_content() {
        if (this.pnl_content == null) {
            this.pnl_content = new JTabbedPane();
            this.pnl_content.addTab(this.CONFIG.getText("InfoBox_Benutzer"), this.getEdt_text());
            this.pnl_content.addTab(this.CONFIG.getText("InfoBox_Vertaege"), this.getTable_Vertraege());
            this.pnl_content.addTab(this.CONFIG.getText("InfoBox_Geraete"), this.getTable_Clients());
            this.pnl_content.addTab(this.CONFIG.getText("InfoBox_Produkte"), this.getTable_Normen());
            this.pnl_content.setMinimumSize(new Dimension(0, 100));
            this.pnl_content.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                    int key = event.getKeyCode();
                    if (event.isControlDown() && key == 123) {
                        if (InfoBox.this.infoshow) {
                            InfoBox.this.pnl_content.remove(3);
                            InfoBox.this.pnl_content.insertTab(InfoBox.this.CONFIG.getText("InfoBox_Produkte"), null, InfoBox.this.getTable_Normen_ext(), null, 3);
                            InfoBox.this.pnl_content.setSelectedIndex(3);
                            InfoBox.this.infoshow = false;
                        } else {
                            InfoBox.this.pnl_content.remove(3);
                            InfoBox.this.pnl_content.insertTab(InfoBox.this.CONFIG.getText("InfoBox_Produkte"), null, InfoBox.this.getTable_Normen(), null, 3);
                            InfoBox.this.pnl_content.setSelectedIndex(3);
                            InfoBox.this.infoshow = true;
                        }
                    }
                }

                public void keyReleased(KeyEvent arg0) {
                }

                public void keyTyped(KeyEvent arg0) {
                }
            });
        }
        return this.pnl_content;
    }

    private JScrollPane getTable_Vertraege() {
        Vector vertraege = this.LICFILE.getVertraege();
        JTable vertraegetable = null;
        Object[][] rowData = new String[vertraege.size()][6];
        int c = 0;
        while (c < vertraege.size()) {
            Lizenz_Vertrag lv = (Lizenz_Vertrag)vertraege.get(c);
            rowData[c][0] = lv.getLizenz_Vertrag_ID();
            rowData[c][1] = lv.getOwner_Firma();
            rowData[c][2] = lv.getOwner_Email();
            rowData[c][3] = lv.getOwner_Kundennummer();
            rowData[c][4] = lv.getLizenziert_von();
            rowData[c][5] = lv.getLizenziert_bis();
            ++c;
        }
        Object[] columnNames = new String[]{this.CONFIG.getText("tt_Lizenz_Vertrag_ID"), this.CONFIG.getText("tt_Lizenz_Vertrag_Owner_Firma"), this.CONFIG.getText("tt_Lizenz_Vertrag_Owner_Email"), this.CONFIG.getText("tt_Lizenz_Vertrag_Owner_Kundennummer"), this.CONFIG.getText("tt_Lizenz_Vertrag_Lizenziert_von"), this.CONFIG.getText("tt_Lizenz_Vertrag_Lizenziert_bis")};
        vertraegetable = new JTable(rowData, columnNames){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                return (String)super.getValueAt(rowIndex, colIndex);
            }
        };
        vertraegetable.setBackground(Color.WHITE);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.white);
        panel.setViewportView(vertraegetable);
        return panel;
    }

    private JScrollPane getTable_Clients() {
        Object[] columnNames = new String[]{this.CONFIG.getText("tt_Lizenz_Client_ID"), this.CONFIG.getText("tt_Lizenz_Client_Benutzer_ID"), this.CONFIG.getText("tt_Lizenz_Client_Geraete_ID"), this.CONFIG.getText("tt_Lizenz_Client_Lizenz_Vertrag_ID"), this.CONFIG.getText("tt_Lizenz_Client_Art"), this.CONFIG.getText("tt_Lizenz_Client_CRTIME"), this.CONFIG.getText("tt_Lizenz_Client_UPDTIME"), this.CONFIG.getText("tt_Lizenz_Client_Status")};
        Vector clients = this.LICFILE.getClients();
        JTable clientstable = null;
        Object[][] rowData = new String[clients.size()][columnNames.length];
        int c = 0;
        while (c < clients.size()) {
            Lizenz_Client lc = (Lizenz_Client)clients.get(c);
            rowData[c] = new String[]{lc.getID().substring(0, 8), lc.getBenutzer_ID(), lc.getGeraete_ID(), lc.getLizenz_Vertrag_ID(), lc.getArt(), lc.getCRTIME(), lc.getUPDTIME(), lc.getStatus()};
            ++c;
        }
        clientstable = new JTable(rowData, columnNames){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                return (String)super.getValueAt(rowIndex, colIndex);
            }
        };
        clientstable.setBackground(Color.WHITE);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.white);
        panel.setViewportView(clientstable);
        return panel;
    }

    private JScrollPane getTable_Normen() {
        Object[] columnNames = new String[]{this.CONFIG.getText("tt_Normen_ID"), this.CONFIG.getText("tt_Normen_Nummer"), this.CONFIG.getText("tt_Normen_Bezeichnung"), this.CONFIG.getText("tt_Normen_View"), this.CONFIG.getText("tt_Normen_Print"), this.CONFIG.getText("tt_Normen_CopyPaste"), this.CONFIG.getText("tt_Normen_Von"), this.CONFIG.getText("tt_Normen_Bis")};
        Vector normen = this.LICFILE.getNormen();
        JTable normentable = null;
        Object[][] rowData = new String[normen.size()][columnNames.length];
        int nc = 0;
        while (nc < normen.size()) {
            Produkt norm = (Produkt)normen.get(nc);
            rowData[nc] = new String[]{norm.getID().substring(0, 8), norm.getProduktnummer(), norm.getBezeichnung(), norm.getRecht_View_str(), norm.getRecht_Print_str(), norm.getRecht_CopyPaste_str(), norm.getLiz_Von(), norm.getLiz_Bis()};
            ++nc;
        }
        normentable = new JTable(rowData, columnNames){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                return (String)super.getValueAt(rowIndex, colIndex);
            }
        };
        normentable.setBackground(Color.WHITE);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.white);
        panel.setViewportView(normentable);
        return panel;
    }

    private JScrollPane getTable_Normen_ext() {
        Object[] columnNames = new String[]{"ID", "CRTIME", "UPDTIME", "Status", "Klasse", "Gruppe", "Untergruppe", "Art", "Produktnummer", "Bezeichnung", "Beschreibung", "Recht_View", "Recht_Print", "Recht_CopyPaste", "Liz_Von", "Liz_Bis", "Dateiname", "Dateipfad", "Sprache_ID", "Sprach_Code", "Info", "Revision", "Revision_Datum", "URL"};
        Vector normen = this.LICFILE.getNormen();
        JTable normentable = null;
        Object[][] rowData = new String[normen.size()][columnNames.length];
        int nc = 0;
        while (nc < normen.size()) {
            Produkt norm = (Produkt)normen.get(nc);
            rowData[nc] = new String[]{norm.getID(), norm.getCRTIME(), norm.getUPDTIME(), norm.getStatus(), norm.getKlasse(), norm.getGruppe(), norm.getUntergruppe(), norm.getArt(), norm.getProduktnummer(), norm.getBezeichnung(), norm.getBeschreibung(), norm.getRecht_View_str(), norm.getRecht_Print_str(), norm.getRecht_CopyPaste_str(), norm.getLiz_Von(), norm.getLiz_Bis(), norm.getDateiname(), norm.getDateipfad(), norm.getSprache_ID(), norm.getSprach_Code(), norm.getInfo(), norm.getRevision(), norm.getRevision_Datum(), norm.getURL()};
            ++nc;
        }
        normentable = new JTable(rowData, columnNames){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                return (String)super.getValueAt(rowIndex, colIndex);
            }
        };
        normentable.setBackground(Color.WHITE);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.white);
        panel.setViewportView(normentable);
        return panel;
    }
}

