/*
 * Decompiled with CFR 0.152.
 */
package gui.form.asspnl;

import gui.form.FormAssistent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import res.Config;
import res.Control;
import res.WebService;
import res.obj.redLizenz_Client;

public class PanelDeviceIDs
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 6112743933196216284L;
    private Config CONFIG;
    private JTable devicelist;
    private JPanel pnl_form;
    private JPanel pnl_buttons;
    private JButton btn_next;
    private JButton btn_close;
    private JTextPane lbl_ende;
    private JPanel pnl_ende;
    private FormAssistent owner;
    private String Benutzer;
    private String Passwort;

    public PanelDeviceIDs(Config CONFIG, FormAssistent owner, String Benutzer, String Passwort) {
        this.CONFIG = CONFIG;
        this.owner = owner;
        this.Benutzer = Benutzer;
        this.Passwort = Passwort;
        this.setPreferredSize(new Dimension(362, 248));
        this.setLayout(new BorderLayout());
        this.setBackground(CONFIG.getBGColor());
        this.init_pnl_buttons();
        this.init_pnl_form();
    }

    private void init_pnl_buttons() {
        this.btn_next = new JButton();
        this.btn_next.setPreferredSize(new Dimension(200, 21));
        this.btn_next.setText(this.CONFIG.getText("DeviceIDs_btn_next"));
        this.btn_next.addActionListener(this);
        this.btn_close = new JButton();
        this.btn_close.setPreferredSize(new Dimension(200, 21));
        this.btn_close.setText(this.CONFIG.getText("DeviceIDs_btn_close"));
        this.btn_close.addActionListener(this);
        this.pnl_buttons = new JPanel();
        this.pnl_buttons.setLayout(new BoxLayout(this.pnl_buttons, 0));
        this.pnl_buttons.setBackground(this.CONFIG.getDefaulBGColor());
    }

    private void init_pnl_form() {
        this.pnl_form = new JPanel();
        this.pnl_form.setLayout(null);
        this.pnl_form.setBackground(this.CONFIG.getBGColor());
        this.setCursor(new Cursor(3));
        WebService ws = new WebService(this.CONFIG);
        Object[] devices = ws.getMyDevice_IDs(this.Benutzer, this.Passwort);
        if (((String)devices[0]).equals("OK")) {
            Object[][] rowData = new String[devices.length - 1][5];
            int c = 0;
            while (c < devices.length - 1) {
                redLizenz_Client lc = (redLizenz_Client)devices[c + 1];
                rowData[c][0] = lc.getID_Device();
                rowData[c][1] = lc.getID_Device().length() >= 8 ? lc.getID_Device().substring(0, 8) : lc.getID_Device();
                rowData[c][2] = lc.getApplication();
                rowData[c][3] = lc.getLetzte_Lizenzierung_am();
                rowData[c][4] = lc.getSource_Changedate();
                ++c;
            }
            Object[] columnNames = new String[]{"ID", this.CONFIG.getText("DeviceIDs_tt_ID"), this.CONFIG.getText("DeviceIDs_tt_Applikation"), this.CONFIG.getText("DeviceIDs_tt_Letzte_Lizenzierung_am"), this.CONFIG.getText("DeviceIDs_tt_Source_Changedate")};
            this.devicelist = new JTable(rowData, columnNames){
                private static final long serialVersionUID = 1L;

                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    int rowIndex = this.rowAtPoint(p);
                    int colIndex = this.columnAtPoint(p);
                    return (String)super.getValueAt(rowIndex, colIndex);
                }
            };
            this.devicelist.setAutoResizeMode(0);
            this.devicelist.getColumnModel().getColumn(0).setMinWidth(0);
            this.devicelist.getColumnModel().getColumn(0).setMaxWidth(0);
            this.devicelist.getColumnModel().getColumn(1).setMinWidth(80);
            this.devicelist.getColumnModel().getColumn(2).setMinWidth(100);
            this.devicelist.getColumnModel().getColumn(3).setMinWidth(60);
            this.devicelist.getColumnModel().getColumn(4).setMinWidth(60);
            this.devicelist.setBackground(this.getBackground());
            JScrollPane sp = new JScrollPane(this.devicelist);
            sp.setBounds(12, 12, 340, 150);
            sp.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            sp.setBackground(this.getBackground());
            this.pnl_form.add(sp);
        } else {
            this.owner.setStatus(this.CONFIG.getText("DeviceIDs_stat_err_getMyDevice_IDs"), true);
        }
        this.pnl_buttons.add(Box.createVerticalStrut(21));
        this.pnl_buttons.add(this.btn_next);
        this.setCursor(new Cursor(12));
        this.removeAll();
        this.add((Component)this.pnl_form, "Center");
        this.owner.setButtons(this.pnl_buttons);
        this.updateUI();
    }

    private void init_pnl_ende() {
        this.pnl_ende = new JPanel();
        this.pnl_ende.setLayout(null);
        this.pnl_ende.setBackground(this.CONFIG.getBGColor());
        this.lbl_ende = new JTextPane();
        this.pnl_ende.add(this.lbl_ende);
        this.lbl_ende.setText(this.CONFIG.getText("DeviceIDs_txt_ende"));
        this.lbl_ende.setBounds(12, 12, 350, 150);
        this.lbl_ende.setBackground(this.CONFIG.getBGColor());
        this.lbl_ende.setEditable(false);
        this.btn_next.setEnabled(false);
        this.removeAll();
        this.add((Component)this.pnl_ende, "Center");
        this.pnl_buttons.removeAll();
        this.pnl_buttons.add(this.btn_close);
        this.owner.setButtons(this.pnl_buttons);
        this.updateUI();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btn_next) {
            if (this.devicelist.getSelectedRow() >= 0) {
                this.owner.showWait(true);
                String Device_ID = (String)this.devicelist.getValueAt(this.devicelist.getSelectedRow(), 0);
                WebService ws = new WebService(this.CONFIG);
                String[] res = ws.deleteMyDevice_ID(this.Benutzer, this.Passwort, Device_ID);
                if (res[0].equals("true")) {
                    this.init_pnl_ende();
                } else {
                    this.owner.setStatus(this.CONFIG.getText("DeviceIDs_stat_err_deleteMyDevice_ID"), true);
                }
                this.owner.showWait(false);
            } else {
                this.owner.setStatus(this.CONFIG.getText("DeviceIDs_txt_no_id_selected"), true);
            }
        }
        if (ev.getSource() == this.btn_close) {
            this.owner.dispose();
            Control.showInfoMessage(this.CONFIG, this.CONFIG.getText("msg_downloadlicfile"));
            this.CONFIG.showWait(true);
            Control.downloadLicFile(this.CONFIG, this.Benutzer, this.Passwort);
            this.CONFIG.showWait(false);
        }
    }
}

