/*
 * Decompiled with CFR 0.152.
 */
package gui.form.asspnl;

import gui.form.FormAssistent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import res.Config;
import res.Control;

public class PanelLogin
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8393130310449961834L;
    private Config CONFIG;
    private JTextPane pnl_text;
    private JTextField edt_benutzer;
    private JButton btn_selectlicfile;
    private JTextField edt_pfad;
    private JTextField edt_pid;
    private JRadioButton rad_offline;
    private JRadioButton rad_online;
    private JPasswordField edt_passwort;
    private JLabel lbl_passwort;
    private JLabel lbl_benutzer;
    private JLabel lbl_pid;
    private JPanel pnl_form;
    private JPanel pnl_erfolg;
    private JPanel pnl_buttons;
    private JButton btn_next;
    private JButton btn_close;
    private JCheckBox cb_syncnow;
    private FormAssistent owner;

    public PanelLogin(Config CONFIG, FormAssistent owner) {
        this.CONFIG = CONFIG;
        this.owner = owner;
        this.setPreferredSize(new Dimension(362, 248));
        this.setLayout(new BorderLayout());
        this.setBackground(CONFIG.getBGColor());
        this.pnl_form = new JPanel();
        this.pnl_form.setLayout(null);
        this.pnl_form.setBackground(CONFIG.getBGColor());
        this.lbl_benutzer = new JLabel();
        this.pnl_form.add(this.lbl_benutzer);
        this.lbl_benutzer.setText(CONFIG.getText("Login_lbl_benutzer"));
        this.lbl_benutzer.setBounds(12, 12, 250, 14);
        this.edt_benutzer = new JTextField();
        this.pnl_form.add(this.edt_benutzer);
        this.edt_benutzer.setText("");
        this.edt_benutzer.setBounds(12, 32, 250, 21);
        this.lbl_passwort = new JLabel();
        this.pnl_form.add(this.lbl_passwort);
        this.lbl_passwort.setText(CONFIG.getText("Login_lbl_passwort"));
        this.lbl_passwort.setBounds(12, 65, 250, 14);
        this.edt_passwort = new JPasswordField();
        this.pnl_form.add(this.edt_passwort);
        this.edt_passwort.setText("");
        this.edt_passwort.setBounds(12, 85, 250, 21);
        this.rad_online = new JRadioButton();
        this.pnl_form.add(this.rad_online);
        this.rad_online.setText(CONFIG.getText("Login_rad_online"));
        this.rad_online.setBounds(12, 124, 250, 18);
        this.rad_online.addActionListener(this);
        this.rad_online.setBackground(CONFIG.getBGColor());
        if (CONFIG.isOnline()) {
            this.rad_online.setSelected(true);
        }
        this.rad_offline = new JRadioButton();
        this.pnl_form.add(this.rad_offline);
        this.rad_offline.setText(CONFIG.getText("Login_rad_offline"));
        this.rad_offline.setBounds(12, 151, 250, 18);
        this.rad_offline.addActionListener(this);
        this.rad_offline.setBackground(CONFIG.getBGColor());
        if (!CONFIG.isOnline()) {
            this.rad_offline.setSelected(true);
        }
        this.edt_pfad = new JTextField();
        this.pnl_form.add(this.edt_pfad);
        this.edt_pfad.setText("");
        this.edt_pfad.setBounds(12, 178, 250, 21);
        this.edt_pfad.setEditable(false);
        this.edt_pfad.setEnabled(false);
        this.btn_selectlicfile = new JButton();
        this.pnl_form.add(this.btn_selectlicfile);
        this.btn_selectlicfile.setText("...");
        this.btn_selectlicfile.setBounds(268, 178, 20, 21);
        this.btn_selectlicfile.addActionListener(this);
        this.btn_selectlicfile.setEnabled(false);
        this.lbl_pid = new JLabel();
        this.pnl_form.add(this.lbl_pid);
        this.lbl_pid.setText(CONFIG.getText("Login_lbl_pid"));
        this.lbl_pid.setBounds(12, 208, 250, 14);
        this.lbl_pid.setVisible(false);
        this.edt_pid = new JTextField();
        this.pnl_form.add(this.edt_pid);
        this.edt_pid.setText("");
        this.edt_pid.setBounds(12, 228, 250, 21);
        this.edt_pid.setEditable(false);
        this.edt_pid.setEnabled(false);
        this.edt_pid.setVisible(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rad_online);
        group.add(this.rad_offline);
        this.cb_syncnow = new JCheckBox();
        this.pnl_buttons = new JPanel();
        this.pnl_buttons.setLayout(new BoxLayout(this.pnl_buttons, 0));
        this.pnl_buttons.setBackground(CONFIG.getDefaulBGColor());
        this.btn_close = new JButton();
        this.btn_close.setPreferredSize(new Dimension(100, 21));
        this.btn_close.setText(CONFIG.getText("Sync_btn_close"));
        this.btn_close.addActionListener(this);
        this.pnl_buttons.add(this.btn_close);
        this.pnl_buttons.add(Box.createVerticalStrut(21));
        this.btn_next = new JButton();
        this.btn_next.setPreferredSize(new Dimension(100, 21));
        this.btn_next.setText(CONFIG.getText("Login_btn_login"));
        this.btn_next.addActionListener(this);
        this.pnl_buttons.add(this.btn_next);
        owner.getRootPane().setDefaultButton(this.btn_next);
        this.pnl_erfolg = new JPanel();
        this.pnl_erfolg.setLayout(null);
        this.pnl_erfolg.setBackground(CONFIG.getBGColor());
        this.pnl_text = new JTextPane();
        this.pnl_erfolg.add(this.pnl_text);
        this.pnl_text.setText(CONFIG.getText("Login_msg_erfolgreich"));
        this.pnl_text.setBounds(12, 87, 338, 128);
        this.pnl_text.setBackground(CONFIG.getBGColor());
        this.pnl_text.setEditable(false);
        this.add((Component)this.pnl_form, "Center");
        owner.setButtons(this.pnl_buttons);
    }

    public String getBenutzer() {
        return this.edt_benutzer.getText();
    }

    public String getPasswort() {
        return new String(this.edt_passwort.getPassword());
    }

    public boolean getOnline() {
        return this.rad_online.isSelected();
    }

    public String getPfad() {
        return this.edt_pfad.getText();
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btn_selectlicfile) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".srl");
                }

                public String getDescription() {
                    return "SecureReader-Lizenz (*.srl)";
                }
            });
            int res = fc.showOpenDialog(this.CONFIG.getMasterFrame());
            if (res == 0) {
                this.edt_pfad.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
        if (ev.getSource() == this.rad_online) {
            this.edt_pfad.setEnabled(false);
            this.btn_selectlicfile.setEnabled(false);
            this.lbl_pid.setVisible(false);
            this.edt_pid.setVisible(false);
        }
        if (ev.getSource() == this.rad_offline) {
            this.edt_pfad.setEnabled(true);
            this.btn_selectlicfile.setEnabled(true);
            this.lbl_pid.setVisible(true);
            this.edt_pid.setVisible(true);
            this.edt_pid.setEnabled(true);
            this.edt_pid.setText(this.CONFIG.getPID());
        }
        if (ev.getSource() == this.btn_next) {
            this.owner.setStatus(this.CONFIG.getText("stat_ws_checkbenutzer"), false);
            this.owner.showWait(true);
            String user = this.edt_benutzer.getText();
            String pw = new String(this.edt_passwort.getPassword());
            if (user.equals("") || pw.equals("")) {
                this.owner.showWait(false);
                Control.showInfoMessage(this.CONFIG, this.CONFIG.getText("Login_msg_no_user_pw"));
            } else if (this.getOnline()) {
                this.owner.setStatus(this.CONFIG.getText("stat_ws_getlizenz"), false);
                Thread worker = new Thread(){

                    public void run() {
                        String user = PanelLogin.this.edt_benutzer.getText();
                        String pw = new String(PanelLogin.this.edt_passwort.getPassword());
                        if (Control.downloadLicFile(PanelLogin.this.CONFIG, user, pw)) {
                            PanelLogin.this.owner.setStatus(PanelLogin.this.CONFIG.getText("stat_bereit"), false);
                            PanelLogin.this.licdownloaded();
                        } else {
                            PanelLogin.this.owner.showWait(false);
                            PanelLogin.this.owner.dispose();
                        }
                    }
                };
                worker.start();
            } else if (!this.getPfad().equals("")) {
                this.owner.setStatus(this.CONFIG.getText("stat_openlizenz"), false);
                if (Control.openLicFile(this.CONFIG, this.edt_pfad.getText(), user, pw)) {
                    this.owner.setStatus(this.CONFIG.getText("stat_bereit"), false);
                    this.pnl_buttons.removeAll();
                    this.pnl_buttons.add(Box.createVerticalStrut(21));
                    this.pnl_buttons.add(this.btn_close);
                    this.removeAll();
                    this.add((Component)this.pnl_erfolg, "Center");
                    this.owner.setButtons(this.pnl_buttons);
                    this.updateUI();
                }
                this.owner.showWait(false);
            } else {
                this.owner.showWait(false);
                Control.showInfoMessage(this.CONFIG, this.CONFIG.getText("Login_msg_nofile"));
            }
        }
        if (ev.getSource() == this.btn_close) {
            if (this.cb_syncnow.isSelected()) {
                this.owner.showSync();
            } else {
                this.owner.dispose();
            }
        }
    }

    private void licdownloaded() {
        this.removeAll();
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 0));
        tmp.setBackground(this.CONFIG.getBGColor());
        tmp.add(Box.createHorizontalStrut(2));
        this.cb_syncnow = new JCheckBox();
        tmp.add(this.cb_syncnow);
        this.cb_syncnow.setText(this.CONFIG.getText("LicAssistent_cb_syncnow"));
        this.cb_syncnow.setBounds(0, 160, 350, 16);
        this.cb_syncnow.setBackground(this.CONFIG.getBGColor());
        this.cb_syncnow.addActionListener(this);
        this.cb_syncnow.setSelected(true);
        this.add((Component)tmp, "South");
        this.pnl_buttons.removeAll();
        this.pnl_buttons.add(Box.createVerticalStrut(21));
        this.pnl_buttons.add(this.btn_close);
        this.add((Component)this.pnl_erfolg, "Center");
        this.owner.setButtons(this.pnl_buttons);
        this.updateUI();
        this.owner.showWait(false);
    }
}

