/*
 * Decompiled with CFR 0.152.
 */
package gui.form.asspnl;

import gui.form.FormAssistent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdom.JDOMException;
import res.Config;
import res.Control;
import res.NormFile;
import res.Produkt;
import res.WebService;

public class PanelSync
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 6112743933196216284L;
    private Config CONFIG;
    private JTable synclist;
    private JPanel pnl_form;
    private JPanel pnl_start;
    private JPanel pnl_ende;
    private JPanel pnl_buttons;
    private JButton btn_search;
    private JButton btn_doit;
    private JButton btn_back;
    private JButton btn_close;
    private JTextPane lbl_start;
    private JProgressBar statusbar;
    private JCheckBox cb_select;
    private JCheckBox cb_updateindex;
    private FormAssistent owner;
    private Vector files = null;
    private Vector foundFiles = null;
    private Object[][] data = null;
    private String[] columnNames = null;
    private static int CHECK = 0;
    private static int NUMMER = 1;
    private static int BEZEICHNUNG = 2;
    private static int INFO = 3;
    private static int ID = 4;
    private static int DO = 5;
    private static int DATEI = 6;
    private int files_updated = 0;
    private int files_downloaded = 0;
    private int files_deleted = 0;
    private Thread worker = null;
    private boolean jumpover = false;
    private int jumped = 0;
    static /* synthetic */ Class class$0;

    public PanelSync(Config CONFIG, FormAssistent owner) {
        this.CONFIG = CONFIG;
        this.owner = owner;
        this.setPreferredSize(new Dimension(362, 248));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.columnNames = new String[]{"", CONFIG.getText("Sync_tt_nummer"), CONFIG.getText("Sync_tt_bezeichnung"), CONFIG.getText("Sync_tt_info"), "ID", "do", "Datei"};
        this.init_pnl_buttons();
        this.init_pnl_start();
    }

    private void init_pnl_buttons() {
        this.btn_close = new JButton();
        this.btn_close.setPreferredSize(new Dimension(100, 21));
        this.btn_close.setText(this.CONFIG.getText("Sync_btn_close"));
        this.btn_close.addActionListener(this);
        this.btn_search = new JButton();
        this.btn_search.setPreferredSize(new Dimension(100, 21));
        this.btn_search.setText(this.CONFIG.getText("Sync_btn_search"));
        this.btn_search.addActionListener(this);
        this.btn_doit = new JButton();
        this.btn_doit.setPreferredSize(new Dimension(200, 21));
        this.btn_doit.setText(this.CONFIG.getText("Sync_btn_doit"));
        this.btn_doit.addActionListener(this);
        this.btn_back = new JButton();
        this.btn_back.setPreferredSize(new Dimension(100, 21));
        this.btn_back.setText(this.CONFIG.getText("Sync_btn_back"));
        this.btn_back.addActionListener(this);
        this.pnl_buttons = new JPanel();
        this.pnl_buttons.setLayout(new BoxLayout(this.pnl_buttons, 0));
    }

    private void updateSynclist() {
        this.synclist = new JTable(new MyTableModel(this.columnNames, this.data)){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                if (colIndex != 0 && rowIndex != 0) {
                    return (String)super.getValueAt(rowIndex, colIndex);
                }
                return "";
            }
        };
        this.synclist.setAutoResizeMode(0);
        this.synclist.setRowHeight(15);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.synclist.setDefaultRenderer(clazz, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (row == table.getSelectedRow()) {
                    hasFocus = true;
                }
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (Integer.parseInt((String)PanelSync.this.data[row][DO]) == 0) {
                    this.setBackground(new Color(245, 245, 245));
                    this.setForeground(new Color(105, 105, 105));
                } else if (!hasFocus) {
                    this.setBackground(Color.WHITE);
                    this.setForeground(Color.BLACK);
                }
                return this;
            }
        });
        this.synclist.getColumnModel().getColumn(CHECK).setPreferredWidth(20);
        this.synclist.getColumnModel().getColumn(NUMMER).setPreferredWidth(70);
        this.synclist.getColumnModel().getColumn(BEZEICHNUNG).setPreferredWidth(110);
        this.synclist.getColumnModel().getColumn(INFO).setPreferredWidth(200);
        this.synclist.getColumnModel().getColumn(ID).setMinWidth(0);
        this.synclist.getColumnModel().getColumn(ID).setMaxWidth(0);
        this.synclist.getColumnModel().getColumn(DO).setPreferredWidth(0);
        this.synclist.getColumnModel().getColumn(DO).setMinWidth(0);
        this.synclist.getColumnModel().getColumn(DO).setMaxWidth(0);
        this.synclist.getColumnModel().getColumn(DATEI).setMinWidth(0);
        this.synclist.getColumnModel().getColumn(DATEI).setMaxWidth(0);
        this.synclist.setBackground(Color.WHITE);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.WHITE);
        panel.setViewportView(this.synclist);
        this.pnl_form.add((Component)panel, "Center");
    }

    private void init_pnl_form() {
        this.owner.showWait(true);
        WebService ws = new WebService(this.CONFIG);
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getLabels"), false);
        ws.getLabels();
        this.CONFIG.loadLabels();
        this.CONFIG.setAnwendungssprachen(ws.getSprachen_per_Anwendung("Anwendungssprache", true));
        this.CONFIG.setDatensprachen(ws.getSprachen_per_Anwendung("Datensprache", true));
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getLinks"), false);
        ws.getLinks(true);
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getAnreden"), false);
        ws.getAnreden(true);
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getBerufstitel"), false);
        ws.getBerufstitel(true);
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getLaender"), false);
        ws.getLaender(true);
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getHelpFile"), false);
        ws.getHelpFile("1");
        ws.getHelpFile("4");
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_getlicfile"), false);
        if (Control.downloadLicFile(this.CONFIG, this.CONFIG.getLICFILE().getKundennummer(), this.CONFIG.getLICFILE().getPasswort())) {
            this.owner.setStatus(this.CONFIG.getText("Sync_stat_getlicfile_ok"), false);
            this.owner.setStatus(this.CONFIG.getText("Sync_stat_searchfiles"), false);
            this.files = new Vector();
            this.foundFiles = new Vector();
            Vector<Produkt> normen = this.CONFIG.getLICFILE().getNormen();
            int doit = 0;
            int anz = 0;
            Vector<Produkt> normfiles = new Vector<Produkt>();
            int c = 0;
            while (c < normen.size()) {
                Produkt norm = (Produkt)normen.get(c);
                boolean check = false;
                int z = 0;
                while (z < normfiles.size()) {
                    Produkt tmp = (Produkt)normfiles.get(z);
                    if (tmp.getID().equals(norm.getID())) {
                        check = true;
                        break;
                    }
                    ++z;
                }
                if (!check) {
                    normfiles.add(norm);
                }
                ++c;
            }
            normen = normfiles;
            Object[][] mydata = new Object[normen.size()][this.columnNames.length];
            int c2 = 0;
            while (c2 < normen.size()) {
                Produkt norm = (Produkt)normen.get(c2);
                String text = "";
                doit = 0;
                String datname = String.valueOf(norm.getDateipfad()) + norm.getDateiname();
                File f = new File(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + datname);
                NormFile dokument = null;
                if (f.exists()) {
                    this.owner.setStatus(String.valueOf(this.CONFIG.getText("Sync_stat_searchfiles_in")) + " " + f.getAbsolutePath(), false);
                    text = this.CONFIG.getText("Sync_msg_upd_ok");
                    dokument = new NormFile(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + datname);
                } else if (!this.CONFIG.getDatenpfad_zentral().equals("")) {
                    this.owner.setStatus(String.valueOf(this.CONFIG.getText("Sync_stat_searchfiles_in")) + " " + f.getAbsolutePath(), false);
                    f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + datname);
                    if (f.exists()) {
                        text = this.CONFIG.getText("Sync_msg_upd_ok");
                        dokument = new NormFile(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + datname);
                    }
                }
                if (dokument == null) {
                    text = this.CONFIG.getText("Sync_msg_upd_noFile");
                    doit = 1;
                    if (this.CONFIG.isDebug()) {
                        System.err.println("Datei Fehlt: " + datname + " ID: " + norm.getID());
                    }
                } else {
                    f = new File(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + datname);
                    this.files.add(String.valueOf(f.getAbsolutePath()) + f.getName());
                    try {
                        if (dokument.open(this.CONFIG.getLICFILE().getSwitch_Name(), this.CONFIG.getLICFILE().getSRD_KEY(), this.CONFIG.getLICFILE().getSRD_IV())) {
                            if (!dokument.checkRevision(norm.getRevision())) {
                                text = this.CONFIG.getText("Sync_msg_upd_oldFile");
                                doit = 2;
                            } else {
                                text = this.CONFIG.getText("Sync_msg_upd_ok");
                                doit = 0;
                            }
                        } else {
                            text = this.CONFIG.getText("Sync_msg_upd_noLic");
                            doit = 3;
                        }
                    }
                    catch (ZipException e1) {
                        text = this.CONFIG.getText("Sync_msg_upd_wrongFile");
                        doit = 2;
                    }
                    catch (IOException e1) {
                        text = this.CONFIG.getText("Sync_msg_upd_wrongFile");
                        doit = 2;
                    }
                    catch (JDOMException e1) {
                        text = this.CONFIG.getText("Sync_msg_upd_wrongFile");
                        doit = 2;
                    }
                }
                mydata[c2] = new Object[]{new Boolean(false), norm.getProduktnummer(), norm.getBezeichnung(), text, norm.getID(), String.valueOf(doit), f};
                if (doit > 0) {
                    ++anz;
                }
                ++c2;
            }
            this.getFiles(this.CONFIG.getDatenpfad_lokal());
            if (this.CONFIG.isDebug()) {
                System.out.println("normen: " + normen.size());
                System.out.println("normfiles: " + normfiles.size());
                System.out.println("vorhandene Dateien: " + this.files.size());
                System.out.println("gefunde Dateien: " + this.foundFiles.size());
                System.out.println("anz: " + anz);
            }
            this.data = new Object[normen.size() + this.foundFiles.size()][this.columnNames.length];
            c2 = 0;
            while (c2 < normen.size()) {
                this.data[c2] = mydata[c2];
                ++c2;
            }
            c2 = 0;
            while (c2 < this.foundFiles.size()) {
                File f = (File)this.foundFiles.get(c2);
                this.owner.setStatus(String.valueOf(this.CONFIG.getText("Sync_stat_searchfiles_in")) + " " + f.getParentFile(), false);
                String text = "";
                doit = 0;
                text = this.CONFIG.getText("Sync_msg_wrongFile");
                doit = 3;
                this.data[normen.size() + c2] = new Object[]{new Boolean(false), "", f.getName(), text, "", String.valueOf(doit), f};
                if (doit > 0) {
                    ++anz;
                }
                ++c2;
            }
            int nix = 0;
            int download = 0;
            int update = 0;
            int del = 0;
            int anderes = 0;
            int i = 0;
            while (i < normen.size() + this.foundFiles.size()) {
                if (this.data[i][DO].equals("0")) {
                    ++nix;
                } else if (this.data[i][DO].equals("1")) {
                    ++download;
                } else if (this.data[i][DO].equals("2")) {
                    ++update;
                } else if (this.data[i][DO].equals("3")) {
                    ++del;
                } else {
                    if (this.CONFIG.isDebug()) {
                        System.out.println(this.data[i][DO] + " " + this.data[i][DATEI]);
                    }
                    ++anderes;
                }
                ++i;
            }
            if (this.CONFIG.isDebug()) {
                System.out.println("0 nothing  = " + nix);
                System.out.println("1 download = " + download);
                System.out.println("2 update   = " + update);
                System.out.println("3 remove   = " + del);
                System.out.println("x anderes  = " + anderes);
            }
            this.btn_doit.setText(this.CONFIG.getText("Sync_btn_doit"));
            this.pnl_form = new JPanel();
            this.pnl_form.setLayout(new BorderLayout());
            this.pnl_form.setBackground(this.CONFIG.getBGColor());
            this.updateSynclist();
            this.owner.setStatus(this.CONFIG.getText("Sync_stat_search_end"), false);
            JPanel oben = new JPanel();
            oben.setLayout(new BoxLayout(oben, 0));
            oben.setPreferredSize(new Dimension(200, 20));
            oben.setBackground(this.CONFIG.getBGColor());
            oben.add(Box.createHorizontalStrut(5));
            this.cb_select = new JCheckBox();
            this.cb_select.setPreferredSize(new Dimension(300, 18));
            this.cb_select.setText(this.CONFIG.getText("Sync_cb_select"));
            this.cb_select.addActionListener(this);
            this.cb_select.setBackground(oben.getBackground());
            this.cb_select.setBounds(5, 5, 200, 18);
            oben.add(this.cb_select);
            oben.add(Box.createHorizontalStrut(10));
            this.statusbar = new JProgressBar();
            this.statusbar.setPreferredSize(new Dimension(300, 20));
            this.statusbar.setVisible(false);
            oben.add(this.statusbar);
            JPanel unten = new JPanel();
            unten.setLayout(new BoxLayout(unten, 0));
            unten.add(Box.createHorizontalStrut(5));
            unten.setBackground(this.CONFIG.getBGColor());
            this.cb_updateindex = new JCheckBox();
            this.cb_updateindex.setPreferredSize(new Dimension(300, 18));
            this.cb_updateindex.setText(this.CONFIG.getText("Sync_cb_updateindex"));
            this.cb_updateindex.addActionListener(this);
            this.cb_updateindex.setBounds(5, 24, 400, 18);
            this.cb_updateindex.setBackground(unten.getBackground());
            unten.add(this.cb_updateindex);
            JPanel pnl = new JPanel();
            pnl.setLayout(new BorderLayout());
            pnl.setPreferredSize(new Dimension(200, 40));
            pnl.setBackground(this.CONFIG.getBGColor());
            pnl.add((Component)oben, "North");
            pnl.add((Component)unten, "South");
            this.pnl_form.add((Component)pnl, "South");
            this.pnl_buttons.removeAll();
            this.pnl_buttons.add(Box.createVerticalStrut(21));
            this.pnl_buttons.add(this.btn_doit);
            this.removeAll();
            this.add((Component)this.pnl_form, "Center");
            this.owner.setButtons(this.pnl_buttons);
            this.owner.showWait(false);
            this.updateUI();
        } else {
            this.owner.dispose();
        }
    }

    private void init_pnl_start() {
        this.jumpover = false;
        this.pnl_start = new JPanel();
        this.pnl_start.setLayout(null);
        this.pnl_start.setBackground(this.CONFIG.getBGColor());
        this.lbl_start = new JTextPane();
        this.pnl_start.add(this.lbl_start);
        this.lbl_start.setText(this.CONFIG.getText("Sync_txt_start"));
        this.lbl_start.setBounds(12, 12, 350, 150);
        this.lbl_start.setBackground(this.CONFIG.getBGColor());
        this.lbl_start.setEditable(false);
        this.pnl_buttons.removeAll();
        this.pnl_buttons.add(this.btn_close);
        this.pnl_buttons.add(Box.createVerticalStrut(21));
        this.pnl_buttons.add(this.btn_search);
        this.removeAll();
        this.add((Component)this.pnl_start, "Center");
        this.owner.setButtons(this.pnl_buttons);
        this.updateUI();
    }

    private void init_pnl_ende() {
        this.pnl_ende = new JPanel();
        this.pnl_ende.setLayout(null);
        this.pnl_ende.setBackground(this.CONFIG.getBGColor());
        JLabel lbl_files_downloaded = new JLabel();
        lbl_files_downloaded.setText(this.CONFIG.getText("Sync_lbl_files_downloaded"));
        lbl_files_downloaded.setBounds(15, 15, 300, 16);
        lbl_files_downloaded.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_downloaded);
        JLabel lbl_files_downloaded_value = new JLabel();
        lbl_files_downloaded_value.setText(String.valueOf(this.files_downloaded));
        lbl_files_downloaded_value.setBounds(330, 15, 50, 16);
        lbl_files_downloaded_value.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_downloaded_value);
        JLabel lbl_files_deleted = new JLabel();
        lbl_files_deleted.setText(this.CONFIG.getText("Sync_lbl_files_deleted"));
        lbl_files_deleted.setBounds(15, 40, 300, 16);
        lbl_files_deleted.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_deleted);
        JLabel lbl_files_deleted_value = new JLabel();
        lbl_files_deleted_value.setText(String.valueOf(this.files_deleted));
        lbl_files_deleted_value.setBounds(330, 40, 50, 16);
        lbl_files_deleted_value.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_deleted_value);
        JLabel lbl_files_updated = new JLabel();
        lbl_files_updated.setText(this.CONFIG.getText("Sync_lbl_files_updated"));
        lbl_files_updated.setBounds(15, 65, 300, 16);
        lbl_files_updated.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_updated);
        JLabel lbl_files_updated_value = new JLabel();
        lbl_files_updated_value.setText(String.valueOf(this.files_updated));
        lbl_files_updated_value.setBounds(330, 65, 50, 16);
        lbl_files_updated_value.setFont(this.CONFIG.getFont(13, 1));
        this.pnl_ende.add(lbl_files_updated_value);
        this.pnl_buttons.removeAll();
        this.pnl_buttons.add(this.btn_back);
        this.pnl_buttons.add(Box.createVerticalStrut(21));
        this.pnl_buttons.add(this.btn_close);
        this.removeAll();
        this.add((Component)this.pnl_ende, "Center");
        this.owner.setButtons(this.pnl_buttons);
        this.updateUI();
    }

    private void getFiles(String pfad) {
        int c;
        File f = new File(pfad);
        File[] list = f.listFiles(new FilenameFilter(){

            public boolean accept(File folder, String file) {
                return file.toLowerCase().endsWith(".srd");
            }
        });
        if (list != null) {
            c = 0;
            while (c < list.length) {
                boolean check = true;
                int i = 0;
                while (i < this.files.size()) {
                    if (((String)this.files.get(i)).equals(String.valueOf(list[c].getAbsolutePath()) + list[c].getName())) {
                        check = false;
                        break;
                    }
                    ++i;
                }
                if (check && list[c].isFile()) {
                    this.foundFiles.add(list[c]);
                }
                ++c;
            }
        }
        list = null;
        list = f.listFiles(new FilenameFilter(){

            public boolean accept(File folder, String file) {
                return !file.toLowerCase().endsWith(".srd");
            }
        });
        if (list != null) {
            c = 0;
            while (c < list.length) {
                this.getFiles(list[c].getAbsolutePath());
                ++c;
            }
        }
    }

    private void behebeDaten() {
        Object[] mydata;
        int anz = 0;
        int c = 0;
        while (c < this.data.length) {
            mydata = this.data[c];
            if (((Boolean)mydata[CHECK]).booleanValue()) {
                ++anz;
            }
            ++c;
        }
        if (this.CONFIG.isDebug()) {
            System.out.println(String.valueOf(anz) + " Dateien zu beheben");
        }
        this.statusbar.setMaximum(anz);
        if (this.cb_updateindex.isSelected()) {
            this.statusbar.setMaximum(anz + 10);
        }
        this.statusbar.setVisible(true);
        anz = 0;
        this.jumped = 0;
        c = 0;
        while (c < this.data.length) {
            mydata = this.data[c];
            if (((Boolean)mydata[CHECK]).booleanValue()) {
                this.statusbar.setValue(anz);
                ++anz;
                switch (Integer.parseInt((String)mydata[DO])) {
                    case 1: {
                        if (!this.downloadDatei(c, this.data[c])) break;
                        ++this.files_downloaded;
                        break;
                    }
                    case 2: {
                        this.removeDatei(c, this.data[c]);
                        if (!this.downloadDatei(c, this.data[c])) break;
                        ++this.files_updated;
                        break;
                    }
                    case 3: {
                        this.removeDatei(c, this.data[c]);
                        ++this.files_deleted;
                        break;
                    }
                    default: {
                        if (!this.CONFIG.isDebug()) break;
                        System.err.println("Fehler: " + mydata[DO] + " " + mydata[DATEI]);
                    }
                }
            }
            ++c;
        }
        this.statusbar.setValue(anz);
        this.updateSynclist();
        if (this.CONFIG.isDebug()) {
            System.out.println(String.valueOf(this.jumped) + " Dateien \u00fcbersprungen");
        }
        if (this.cb_updateindex.isSelected()) {
            this.owner.setStatus(this.CONFIG.getText("Sync_stat_downloadLucene"), false);
            WebService ws = new WebService(this.CONFIG);
            ws.getLuceneIndex();
            this.statusbar.setValue(anz + 10);
        }
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_upd_ende"), false);
        this.owner.showWait(false);
    }

    private boolean downloadDatei(int id, Object[] odata) {
        String fehler_detail;
        String fehler_info;
        boolean fehler;
        block20: {
            File f = (File)odata[DATEI];
            this.owner.setStatus(this.CONFIG.getText("Sync_stat_downloadFile").replaceAll("FILENAME", f.getName()), false);
            fehler = false;
            fehler_info = "";
            fehler_detail = "";
            WebService ws = new WebService(this.CONFIG);
            try {
                String[] res = ws.getDokument((String)odata[ID]);
                if (res[0].equals("OK")) {
                    NormFile nf = new NormFile(res[1]);
                    if (nf.open(this.CONFIG.getLICFILE().getSwitch_Name(), this.CONFIG.getLICFILE().getSRD_KEY(), this.CONFIG.getLICFILE().getSRD_IV())) {
                        String tmp = nf.saveTo(this.CONFIG.getDatenpfad_lokal());
                        this.owner.setStatus(this.CONFIG.getText("Sync_stat_FileDownloaded").replaceAll("FILENAME", f.getName()), false);
                        this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileDownloaded").replaceAll("FILENAME", f.getName());
                        this.data[id][PanelSync.DO] = "0";
                        this.data[id][PanelSync.CHECK] = new Boolean(false);
                        if (this.CONFIG.isDebug()) {
                            System.out.println("downloaded + saved: " + tmp);
                        }
                    } else {
                        this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileNotDownloaded").replaceAll("FILENAME", f.getName());
                        fehler = true;
                        if (this.CONFIG.isDebug()) {
                            System.out.println(String.valueOf(f.getName()) + " fehler beim \u00f6ffnen");
                        }
                    }
                } else {
                    this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileNotDownloaded").replaceAll("FILENAME", f.getName());
                    fehler = true;
                    if (this.CONFIG.isDebug()) {
                        System.out.println(String.valueOf(f.getName()) + " fehler beim download (" + (String)odata[ID] + ") | " + res[0] + " | " + res[1]);
                    }
                }
            }
            catch (IOException e1) {
                fehler_info = "IOException";
                fehler_detail = e1.getMessage();
                this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileNotDownloaded").replaceAll("FILENAME", f.getName());
                fehler = true;
                if (this.CONFIG.isDebug()) {
                    System.out.println(String.valueOf(f.getName()) + " IOException");
                }
            }
            catch (JDOMException e1) {
                fehler_info = "JDOMException";
                fehler_detail = e1.getMessage();
                this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileNotDownloaded").replaceAll("FILENAME", f.getName());
                fehler = true;
                if (this.CONFIG.isDebug()) {
                    System.out.println(String.valueOf(f.getName()) + " JDOMException");
                }
            }
            catch (OutOfMemoryError e1) {
                fehler_info = "OutOfMemoryError";
                fehler_detail = e1.getMessage();
                this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileNotDownloaded").replaceAll("FILENAME", f.getName());
                fehler = true;
                if (!this.CONFIG.isDebug()) break block20;
                System.out.println(String.valueOf(f.getName()) + " OutOfMemoryError");
            }
        }
        if (fehler) {
            ++this.jumped;
            if (!this.jumpover) {
                Object[] options = new Object[]{this.CONFIG.getText("Sync_opt_redo"), this.CONFIG.getText("Sync_opt_next"), this.CONFIG.getText("Sync_jump"), this.CONFIG.getText("Sync_abort")};
                int n = JOptionPane.showOptionDialog(this, this.CONFIG.getText("Sync_opt_title"), this.CONFIG.getText("msg_info"), 1, 3, null, options, options[0]);
                if (n == 0) {
                    this.downloadDatei(id, odata);
                } else if (n == 2) {
                    this.jumpover = true;
                } else if (n == 3) {
                    this.owner.setStatus(this.CONFIG.getText("Sync_stat_upd_aborted"), true);
                    this.updateSynclist();
                    Control.addLog(this.CONFIG, "Stoppe Synchronisation", "Synchronisation Abgebrochen durch Benutzer wegen Downloadfehler", new String[]{String.valueOf(this.files_downloaded), String.valueOf(this.files_deleted), String.valueOf(this.files_updated), (String)this.data[id][ID], fehler_info, fehler_detail});
                    this.owner.showWait(false);
                    this.init_pnl_ende();
                    this.owner.setStatus(this.CONFIG.getText("Sync_stat_upd_aborted"), true);
                    this.worker.stop();
                }
            }
        }
        return !fehler;
    }

    private void removeDatei(int id, Object[] odata) {
        File f = (File)odata[DATEI];
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_deleteFile").replaceAll("FILENAME", f.getName()), false);
        f.delete();
        this.owner.setStatus(this.CONFIG.getText("Sync_stat_FileDeleted").replaceAll("FILENAME", f.getName()), false);
        this.data[id][PanelSync.INFO] = this.CONFIG.getText("Sync_stat_FileDeleted").replaceAll("FILENAME", f.getName());
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.btn_back) {
            this.init_pnl_start();
        }
        if (ev.getSource() == this.btn_search) {
            Thread searchworker = new Thread(){

                public void run() {
                    PanelSync.this.init_pnl_form();
                }
            };
            searchworker.start();
        }
        if (ev.getSource() == this.btn_doit) {
            if (this.btn_doit.getText().equals(this.CONFIG.getText("Sync_btn_abort"))) {
                Control.addLog(this.CONFIG, "Stoppe Synchronisation", "Synchronisation Abgebrochen durch Benutzer", new String[]{String.valueOf(this.files_downloaded), String.valueOf(this.files_deleted), String.valueOf(this.files_updated)});
                this.owner.showWait(false);
                this.init_pnl_ende();
                this.owner.setStatus(this.CONFIG.getText("Sync_stat_upd_aborted"), true);
                this.worker.stop();
            } else {
                Control.addLog(this.CONFIG, "Starte Synchronisation", "", new String[0]);
                this.statusbar.setVisible(true);
                this.worker = new Thread(){

                    public void run() {
                        PanelSync.this.btn_doit.setText(PanelSync.this.CONFIG.getText("Sync_btn_abort"));
                        PanelSync.this.owner.showWait(true);
                        PanelSync.this.behebeDaten();
                        PanelSync.this.init_pnl_ende();
                        PanelSync.this.owner.setStatus(PanelSync.this.CONFIG.getText("Sync_stat_upd_ende"), false);
                        Control.addLog(PanelSync.this.CONFIG, "Synchronisation beendet", "Synchronisation erfolgreich beendet", new String[]{String.valueOf(PanelSync.this.files_downloaded), String.valueOf(PanelSync.this.files_deleted), String.valueOf(PanelSync.this.files_updated)});
                    }
                };
                this.worker.start();
            }
        }
        if (ev.getSource() == this.btn_close) {
            this.owner.dispose();
        }
        if (ev.getSource() == this.cb_select) {
            int c = 0;
            while (c < this.data.length) {
                Object[] mydata = this.data[c];
                if (!((String)this.data[c][DO]).equals("") && Integer.parseInt((String)this.data[c][DO]) != 0) {
                    this.data[c] = new Object[]{new Boolean(this.cb_select.isSelected()), mydata[NUMMER], mydata[BEZEICHNUNG], mydata[INFO], mydata[ID], mydata[DO], mydata[DATEI]};
                }
                ++c;
            }
            this.synclist.repaint();
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = null;
        private Object[][] data = null;

        public MyTableModel(String[] columnNames, Object[][] data) {
            this.columnNames = columnNames;
            this.data = data;
        }

        public void setData(Object[][] data) {
            this.data = data;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            if (col > 0) {
                return false;
            }
            if (!((String)this.data[row][DO]).equals("")) {
                return Integer.parseInt((String)this.data[row][DO]) != 0;
            }
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

