/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import org.jpedal.objects.PdfPageData;

public final class PageOffsets {
    protected int totalSingleWidth = 0;
    protected int totalDoubleWidth = 0;
    protected int gaps = 0;
    protected int doubleGaps = 0;
    protected int totalSingleHeight = 0;
    protected int totalDoubleHeight = 0;
    protected static final int pageGap = 10;
    protected int doublePageWidth = 0;
    protected int doublePageHeight = 0;
    protected int biggestWidth = 0;
    protected int biggestHeight = 0;
    protected int widestPageNR;
    protected int widestPageR;
    protected boolean hasRotated;

    public PageOffsets(int pageCount, PdfPageData pageData) {
        int facingW = 0;
        int facingH = 0;
        int greatestW = 0;
        int greatestH = 0;
        this.totalSingleHeight = 0;
        this.totalSingleWidth = 0;
        this.hasRotated = false;
        int widestLeftPage = 0;
        int widestRightPage = 0;
        int highestLeftPage = 0;
        int highestRightPage = 0;
        this.widestPageR = 0;
        this.widestPageNR = 0;
        this.totalDoubleWidth = 0;
        this.totalDoubleHeight = 0;
        this.gaps = 0;
        this.doubleGaps = 0;
        this.biggestWidth = 0;
        this.biggestHeight = 0;
        int i = 1;
        while (i < pageCount + 1) {
            int pageW = pageData.getCropBoxWidth(i);
            int pageH = pageData.getCropBoxHeight(i);
            int rotation = pageData.getRotation(i);
            if (rotation == 90 || rotation == 270) {
                int tmp = pageW;
                pageW = pageH;
                pageH = tmp;
            }
            this.gaps += 10;
            this.totalSingleWidth += pageW;
            this.totalSingleHeight += pageH;
            if ((i & 1) == 1) {
                if (widestRightPage < pageW) {
                    widestRightPage = pageW;
                }
                if (highestRightPage < pageH) {
                    highestRightPage = pageH;
                }
            } else {
                if (widestLeftPage < pageW) {
                    widestLeftPage = pageW;
                }
                if (highestLeftPage < pageH) {
                    highestLeftPage = pageH;
                }
            }
            if (this.widestPageNR < pageW) {
                this.widestPageNR = pageW;
            }
            if (this.widestPageR < pageH) {
                this.widestPageR = pageH;
            }
            if (pageW > this.biggestWidth) {
                this.biggestWidth = pageW;
            }
            if (pageH > this.biggestHeight) {
                this.biggestHeight = pageH;
            }
            if ((i & 1) == 1) {
                if (greatestW < pageW) {
                    greatestW = pageW;
                }
                if (greatestH < pageH) {
                    greatestH = pageH;
                }
                if (i == 1) {
                    this.totalDoubleWidth = pageW;
                    this.totalDoubleHeight = pageH;
                } else {
                    this.totalDoubleWidth += greatestW;
                    this.totalDoubleHeight += greatestH;
                }
                this.doubleGaps += 10;
                facingW = pageW;
                facingH = pageH;
            } else {
                facingW += pageW;
                facingH += pageH;
                greatestW = pageW;
                greatestH = pageH;
                if (i == pageCount) {
                    this.totalDoubleWidth = this.totalDoubleWidth + greatestW + 10;
                    this.totalDoubleHeight = this.totalDoubleHeight + greatestH + 10;
                }
            }
            int max = facingW;
            if (max < facingH) {
                max = facingH;
            }
            ++i;
        }
        this.doublePageWidth = widestLeftPage + widestRightPage + 10;
        this.doublePageHeight = highestLeftPage + highestRightPage + 10;
        this.totalSingleWidth -= 10;
        this.totalSingleHeight -= 10;
    }
}

