/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;

public class SingleDisplay
implements Display {
    boolean isGeneratingOtherPages = false;
    Rectangle userAnnot = null;
    AffineTransform rawAf;
    Shape rawClip;
    DynamicVectorRenderer currentDisplay;
    boolean running = false;
    protected PageOffsets currentOffset;
    protected int volatileWidth;
    protected int volatileHeight;
    int startViewPage = 0;
    int endViewPage = 0;
    Map pagesDrawn = new HashMap();
    Map cachedPageViews = new WeakHashMap();
    Map currentPageViews = new HashMap();
    boolean screenNeedsRedrawing;
    PdfDecoder pdf;
    protected Vector_Int offsets = new Vector_Int(3);
    protected Map newPages = new HashMap();
    protected int currentXOffset = 0;
    protected int additionalPageCount = 0;
    float oldScaling = -1.0f;
    float oldRotation = -1.0f;
    float oldVolatileWidth = -1.0f;
    float oldVolatileHeight = -1.0f;
    int indent = 0;
    int[] xReached;
    int[] yReached;
    int[] pageW;
    int[] pageH;
    boolean[] isRotated;
    Map accleratedPagesAlreadyDrawn = new HashMap();
    boolean overRideAcceleration = false;
    private boolean message = false;
    int displayRotation;
    int displayView = 1;
    int insetW;
    int insetH;
    float scaling;
    int pageNumber;
    int pageCount = 0;
    PdfPageData pageData = null;
    private int lastPageChecked = -1;
    private int lastState = -1;
    Graphics2D g2;
    Rectangle[] areas;
    boolean useAcceleration = true;
    boolean isInitialised;
    int rx = 0;
    int ry = 0;
    int rw = 0;
    int rh = 0;
    int crx;
    int cry;
    int crw;
    int crh;
    int CURRENT_BORDER_STYLE = 1;
    AffineTransform current2 = null;
    Shape currentClip = null;
    protected Border myBorder;
    VolatileImage backBuffer = null;
    int topW;
    int topH;
    double cropX;
    double cropY;
    double cropW;
    double cropH;
    boolean thumbnailsRunning;
    protected GUIThumbnailPanel thumbnails = null;

    public SingleDisplay(int pageNumber, int pageCount, DynamicVectorRenderer currentDisplay) {
        this.pageNumber = pageNumber;
        this.pageCount = pageCount;
        this.currentDisplay = currentDisplay;
    }

    public SingleDisplay(PdfDecoder pdf) {
        this.pdf = pdf;
    }

    public void clearAdditionalPages() {
        this.offsets.clear();
        this.newPages.clear();
        this.currentXOffset = 0;
        this.additionalPageCount = 0;
    }

    public void addAdditionalPage(DynamicVectorRenderer dynamicRenderer, int pageWidth, int origPageWidth) {
        this.offsets.addElement(this.currentXOffset + origPageWidth);
        this.newPages.put(new Integer(this.currentXOffset + origPageWidth), dynamicRenderer);
        ++this.additionalPageCount;
        this.currentXOffset += pageWidth;
        this.oldScaling = -this.oldScaling;
        this.refreshDisplay();
    }

    protected void createBackBuffer() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
            this.backBuffer = null;
        }
        int width = 0;
        int height = 0;
        if (this.displayView == 1) {
            if (this.displayRotation == 90 | this.displayRotation == 270) {
                width = this.volatileHeight + this.currentXOffset;
                height = this.volatileWidth;
            } else {
                width = this.volatileWidth + this.currentXOffset;
                height = this.volatileHeight;
            }
        } else if (this.currentOffset != null) {
            int biggestFacingHeight = 0;
            if (this.displayView == 3 && this.pageW != null) {
                int p1 = this.pageNumber;
                if ((p1 & 1) == 1) {
                    --p1;
                }
                int p2 = p1 + 1;
                biggestFacingHeight = this.pageH[p1];
                if (p2 < this.pageH.length && biggestFacingHeight < this.pageH[p2]) {
                    biggestFacingHeight = this.pageH[p2];
                }
            }
            int gaps = this.currentOffset.gaps;
            int doubleGaps = this.currentOffset.doubleGaps;
            switch (this.displayView) {
                case 3: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        width = (int)((float)(this.currentOffset.doublePageHeight + this.insetW) * this.scaling);
                        height = biggestFacingHeight;
                        break;
                    }
                    width = (int)((float)(this.currentOffset.doublePageWidth + this.insetW) * this.scaling);
                    height = biggestFacingHeight;
                    break;
                }
                case 2: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        width = (int)((float)this.currentOffset.biggestHeight * this.scaling);
                        height = (int)((float)this.currentOffset.totalSingleWidth * this.scaling) + gaps + this.insetH;
                        break;
                    }
                    width = (int)((float)this.currentOffset.biggestWidth * this.scaling);
                    height = (int)((float)this.currentOffset.totalSingleHeight * this.scaling) + gaps + this.insetH;
                    break;
                }
                case 4: {
                    if (this.displayRotation == 90 | this.displayRotation == 270) {
                        width = (int)((float)this.currentOffset.doublePageHeight * this.scaling) + this.insetW * 2 + doubleGaps;
                        height = (int)((float)this.currentOffset.totalDoubleWidth * this.scaling) + doubleGaps + this.insetH;
                        break;
                    }
                    width = (int)((float)this.currentOffset.doublePageWidth * this.scaling) + this.insetW * 2;
                    height = (int)((float)this.currentOffset.totalDoubleHeight * this.scaling) + doubleGaps + this.insetH;
                }
            }
        }
        try {
            if (height > 15000) {
                this.volatileHeight = 0;
                height = 0;
                this.overRideAcceleration = true;
            }
            if (width > 0 && height > 0) {
                this.backBuffer = this.pdf.createVolatileImage(width, height);
                this.oldVolatileWidth = this.volatileWidth;
                this.oldVolatileHeight = this.volatileHeight;
                Graphics2D gg = (Graphics2D)this.backBuffer.getGraphics();
                gg.setPaint(this.pdf.getBackground());
                gg.fillRect(0, 0, width, height);
            }
        }
        catch (Error e) {
            this.overRideAcceleration = true;
            this.backBuffer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currentDisplay.setOptimsePainting(true);
    }

    public boolean isAccelerated() {
        return this.useAcceleration && !this.overRideAcceleration;
    }

    public void resetCachedValues() {
        this.lastPageChecked = -1;
        this.lastState = -1;
    }

    public void stopGeneratingPage() {
        this.isGeneratingOtherPages = false;
        while (this.running) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void disableScreen() {
        this.isInitialised = false;
    }

    boolean testAcceleratedRendering() {
        boolean canDrawAccelerated = false;
        if (this.oldScaling != this.scaling || this.oldRotation != (float)this.displayRotation || this.oldVolatileWidth != (float)this.volatileWidth || this.oldVolatileHeight != (float)this.volatileHeight) {
            this.backBuffer = null;
            this.overRideAcceleration = false;
        }
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("acceleration called " + this.backBuffer);
        }
        if (!this.overRideAcceleration && this.backBuffer == null) {
            this.createBackBuffer();
            this.accleratedPagesAlreadyDrawn.clear();
        }
        if (this.backBuffer != null) {
            do {
                int valCode = 2;
                if (this.backBuffer != null) {
                    valCode = this.backBuffer.validate(this.pdf.getGraphicsConfiguration());
                }
                if (valCode != 1 && valCode == 2 && !this.overRideAcceleration) {
                    this.createBackBuffer();
                }
                if (this.backBuffer == null) continue;
                canDrawAccelerated = true;
            } while (this.backBuffer == null || this.backBuffer.contentsLost());
        }
        return canDrawAccelerated;
    }

    public Dimension getPageSize(int displayView) {
        Dimension pageSize = null;
        int biggestFacingHeight = 0;
        if (displayView == 3 && this.pageW != null) {
            int p1 = this.pageNumber;
            if ((p1 & 1) == 1) {
                --p1;
            }
            int p2 = p1 + 1;
            if (this.displayRotation == 90 | this.displayRotation == 270) {
                biggestFacingHeight = this.pageW[p1];
                if (p2 < this.pageW.length && biggestFacingHeight < this.pageW[p2]) {
                    biggestFacingHeight = this.pageW[p2];
                }
            } else {
                biggestFacingHeight = this.pageH[p1];
                if (p2 < this.pageH.length && biggestFacingHeight < this.pageH[p2]) {
                    biggestFacingHeight = this.pageH[p2];
                }
            }
        }
        int gaps = this.currentOffset.gaps;
        int doubleGaps = this.currentOffset.doubleGaps;
        switch (displayView) {
            case 3: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    pageSize = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)biggestFacingHeight * this.scaling + (float)this.insetH + (float)this.insetH));
                    break;
                }
                pageSize = new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)biggestFacingHeight * this.scaling + (float)this.insetH + (float)this.insetH));
                break;
            }
            case 2: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    pageSize = new Dimension((int)((float)this.currentOffset.biggestHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleWidth * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                    break;
                }
                pageSize = new Dimension((int)((float)this.currentOffset.biggestWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalSingleHeight * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                break;
            }
            case 4: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    if (this.pageCount == 2) {
                        pageSize = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestWidth * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH));
                        break;
                    }
                    pageSize = new Dimension((int)((float)this.currentOffset.doublePageHeight * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleWidth * this.scaling + (float)doubleGaps + (float)this.insetH + (float)this.insetH));
                    break;
                }
                pageSize = this.pageCount == 2 ? new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.biggestHeight * this.scaling + (float)gaps + (float)this.insetH + (float)this.insetH)) : new Dimension((int)((float)this.currentOffset.doublePageWidth * this.scaling + (float)this.insetW + (float)this.insetW), (int)((float)this.currentOffset.totalDoubleHeight * this.scaling + (float)doubleGaps + (float)this.insetH + (float)this.insetH));
            }
        }
        return pageSize;
    }

    public Rectangle getDisplayedRectangle() {
        Rectangle userAnnot = this.pdf.getVisibleRect();
        this.rx = userAnnot.x;
        this.ry = userAnnot.y;
        this.rw = userAnnot.width;
        this.rh = userAnnot.height;
        return userAnnot;
    }

    public void drawBorder() {
        if (PdfDecoder.CURRENT_BORDER_STYLE == 1 && this.crw > 0 && this.crh > 0 && this.myBorder != null) {
            this.myBorder.paintBorder(this.pdf, this.g2, this.crx - 1, this.cry - 1, this.crw + 1, this.crh + 1);
        }
    }

    void setDisplacementOnG2(Graphics2D gBB) {
        float cX = (float)this.crx / this.scaling;
        float cY = (float)this.cry / this.scaling;
        if (this.displayRotation == 0 || this.displayView != 1) {
            gBB.translate(-cX, cY);
        } else if (this.displayRotation == 90) {
            gBB.translate(-cY, -cX);
        } else if (this.displayRotation == 180) {
            gBB.translate(cX, -cY);
        } else if (this.displayRotation == 270) {
            gBB.translate(cY, cX);
        }
    }

    protected void getPageView(PdfObject Resources, PdfObject pdfObject, DynamicVectorRenderer currentDisplay, int pageNumber) {
        PdfStreamDecoder current = new PdfStreamDecoder(this.pdf.useHiResImageForDisplay);
        current.setExternalImageRender(this.pdf.customImageHandler);
        current.setName(this.pdf.filename);
        current.setStore(this.pdf.objectStoreRef);
        currentDisplay.setHiResImageForDisplayMode(this.pdf.useHiResImageForDisplay);
        try {
            current.init(true, true, 7, 0, this.pageData, pageNumber, currentDisplay, this.pdf.currentPdfFile);
            if (this.pdf.globalResources != null) {
                current.readResources(this.pdf.globalResources, true);
            }
            if (Resources != null) {
                current.readResources(Resources, true);
            }
            int mediaW = this.pageData.getMediaBoxWidth(pageNumber);
            int mediaH = this.pageData.getMediaBoxHeight(pageNumber);
            int rotation = this.pageData.getRotation(pageNumber);
            currentDisplay.init(mediaW, mediaH, rotation);
            current.decodePageContent(pdfObject, 0, 0, null, null);
        }
        catch (Exception mediaW) {
        }
        catch (Error err) {
            this.pdf.decodeStatus = String.valueOf(this.pdf.decodeStatus) + "Error in decoding page " + err.toString();
            System.out.println(err);
        }
    }

    public void refreshDisplay() {
        this.screenNeedsRedrawing = true;
        this.accleratedPagesAlreadyDrawn.clear();
        this.overRideAcceleration = false;
    }

    public void flushPageCaches() {
        this.currentPageViews.clear();
        this.cachedPageViews.clear();
    }

    public void init(float scaling, int pageCount, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit, PdfPageData pageData, int insetW, int insetH) {
        this.currentDisplay = currentDisplay;
        this.scaling = scaling;
        this.pageCount = pageCount;
        this.displayRotation = displayRotation;
        this.pageNumber = pageNumber;
        this.pageData = pageData;
        this.insetW = insetW;
        this.insetH = insetH;
        currentDisplay.setInset(insetW, insetH);
        pageData.setScalingValue(scaling);
        this.volatileWidth = pageData.getScaledCropBoxWidth(this.pageNumber);
        this.volatileHeight = pageData.getScaledCropBoxHeight(this.pageNumber);
        if (isInit) {
            this.lastPageChecked = -1;
            this.setPageOffsets(pageCount, this.pageNumber);
            this.isInitialised = true;
        }
    }

    public void setPageOffsets(int pageCount, int pageNumber) {
        if (this.displayView == 1) {
            return;
        }
        this.lastPageChecked = pageNumber;
        this.lastState = this.displayView;
        this.xReached = new int[pageCount + 1];
        this.yReached = new int[pageCount + 1];
        this.pageW = new int[pageCount + 1];
        this.pageH = new int[pageCount + 1];
        int heightCorrection = 0;
        int displayRotation = 0;
        this.isRotated = new boolean[pageCount + 1];
        int gap = 10;
        int LmaxWidth = 0;
        int LmaxHeight = 0;
        int RmaxWidth = 0;
        int RmaxHeight = 0;
        int i = 0;
        while (i < pageCount + 1) {
            this.pageW[i] = this.pageData.getScaledCropBoxWidth(i);
            this.pageH[i] = this.pageData.getScaledCropBoxHeight(i);
            displayRotation = this.pageData.getRotation(i) + this.displayRotation;
            if (displayRotation >= 360) {
                displayRotation -= 360;
            }
            if (displayRotation == 90 || displayRotation == 270) {
                int tmp = this.pageW[i];
                this.pageW[i] = this.pageH[i];
                this.pageH[i] = tmp;
                this.isRotated[i] = true;
            }
            if ((i & 1) == 1) {
                if (this.pageW[i] > RmaxWidth) {
                    RmaxWidth = this.pageW[i];
                }
                if (this.pageH[i] > RmaxHeight) {
                    RmaxHeight = this.pageH[i];
                }
            } else {
                if (this.pageW[i] > LmaxWidth) {
                    LmaxWidth = this.pageW[i];
                }
                if (this.pageH[i] > LmaxHeight) {
                    LmaxHeight = this.pageH[i];
                }
            }
            ++i;
        }
        i = 1;
        while (i < pageCount + 1) {
            heightCorrection = 0;
            if (pageCount == 2 && (this.displayView == 3 || this.displayView == 4)) {
                if (i == 1) {
                    this.xReached[1] = 0;
                    this.yReached[1] = 0;
                } else {
                    this.xReached[2] = this.xReached[1] + this.pageW[1] + gap;
                    this.yReached[2] = 0;
                }
            } else if (i == 1) {
                if (this.displayView == 2) {
                    this.xReached[1] = 0;
                    this.yReached[1] = 0;
                } else if (this.displayView == 3 || this.displayView == 4) {
                    if (this.isRotated[i]) {
                        this.xReached[1] = LmaxWidth + gap;
                        this.yReached[1] = this.yReached[i] = this.yReached[i];
                    } else {
                        this.xReached[1] = LmaxWidth + gap;
                        this.yReached[1] = 0;
                    }
                }
            } else if (this.displayView == 4) {
                if ((i & 1) == 0) {
                    int temp;
                    if (i < pageCount) {
                        heightCorrection = (this.pageH[i + 1] - this.pageH[i]) / 2;
                    }
                    if (heightCorrection < 0) {
                        heightCorrection = 0;
                    }
                    if (i > 3 && (temp = (this.pageH[i - 2] - this.pageH[i - 1]) / 2) > 0) {
                        heightCorrection += temp;
                    }
                    this.yReached[i] = this.yReached[i - 1] + this.pageH[i - 1] + gap + heightCorrection;
                } else {
                    heightCorrection = (this.pageH[i - 1] - this.pageH[i]) / 2;
                    this.yReached[i] = this.yReached[i - 1] + heightCorrection;
                }
                this.xReached[i] = (i & 1) == 0 ? this.xReached[i] + (LmaxWidth - this.pageW[i]) : this.xReached[i - 1] + this.pageW[i - 1] + gap;
            } else if (this.displayView == 2) {
                this.yReached[i] = this.yReached[i - 1] + this.pageH[i - 1] + gap;
                if (this.isRotated[i]) {
                    this.xReached[i] = this.xReached[i] - (LmaxWidth - this.pageW[i]) / 2;
                }
            } else if (this.displayView == 3) {
                if ((i & 1) == 1) {
                    this.xReached[i] = this.xReached[i - 1] + this.pageW[i - 1] + gap;
                    if (this.pageH[i] < this.pageH[i - 1]) {
                        this.yReached[i] = this.yReached[i] + (this.pageH[i - 1] - this.pageH[i]) / 2;
                    }
                } else {
                    this.xReached[i] = (LmaxWidth - this.pageW[i]) / 2;
                    if (i < pageCount && this.pageH[i] < this.pageH[i + 1]) {
                        this.yReached[i] = this.yReached[i] + (this.pageH[i + 1] - this.pageH[i]) / 2;
                    }
                }
            }
            ++i;
        }
        this.pdf.setMultiPageOffsets(this.xReached, this.yReached);
    }

    public void decodeOtherPages(int pageNumber, int pageCount) {
    }

    public void completeForm(Graphics2D g2) {
        g2.drawLine(this.crx, this.cry, this.crx + this.crw, this.cry + this.crh);
        g2.drawLine(this.crx, this.crh + this.cry, this.crw + this.crx, this.cry);
    }

    public void resetToDefaultClip() {
        if (this.current2 != null) {
            this.g2.setTransform(this.current2);
        }
        if (this.currentClip != null) {
            this.g2.setClip(this.currentClip);
        }
    }

    public void initRenderer(Rectangle[] areas, Graphics2D g2, Border myBorder, int indent) {
        this.rawAf = g2.getTransform();
        this.rawClip = g2.getClip();
        this.areas = areas;
        this.g2 = g2;
        this.myBorder = myBorder;
        this.indent = indent;
        this.pagesDrawn.clear();
        this.setPageSize(this.pageNumber, this.scaling);
    }

    void setPageSize(int pageNumber, float scaling) {
        this.pageData.setScalingValue(scaling);
        this.topW = this.pageData.getScaledCropBoxWidth(pageNumber);
        this.topH = this.pageData.getScaledCropBoxHeight(pageNumber);
        double mediaH = this.pageData.getScaledMediaBoxHeight(pageNumber);
        this.cropX = this.pageData.getScaledCropBoxX(pageNumber);
        this.cropY = this.pageData.getScaledCropBoxY(pageNumber);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int offsetY = (int)(mediaH - this.cropH);
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            this.crw = (int)this.cropH;
            this.crh = (int)this.cropW;
            int tmp = this.crx;
            this.crx = this.cry;
            this.cry = tmp;
            this.crx += offsetY;
        } else {
            this.crw = (int)this.cropW;
            this.crh = (int)this.cropH;
            this.cry += offsetY;
        }
        this.g2.translate(this.insetW - this.crx, this.insetH - this.cry);
        this.current2 = this.g2.getTransform();
        this.currentClip = this.g2.getClip();
        this.g2.clip(new Rectangle(this.crx, this.cry, (int)((float)this.crw + ((float)(this.insetW * this.additionalPageCount) + (float)this.currentXOffset * scaling)), this.crh));
    }

    Rectangle calcVisibleArea(int topY, int topX) {
        Rectangle userAnnot;
        int x = 0;
        int y = 0;
        int gap = 0;
        this.getDisplayedRectangle();
        if (this.displayRotation != 270 && this.displayRotation != 180 && this.rx > this.insetW) {
            x = (int)((float)(this.rx - this.insetW) / this.scaling);
        }
        int w = (int)((float)(this.rw + this.insetW) / this.scaling);
        int h = topY;
        if (this.displayRotation == 0 || this.displayView != 1) {
            x = (int)((float)this.rx / this.scaling) - (int)((float)this.insetW / this.scaling);
            h = (int)((float)(this.rh + this.insetH) / this.scaling);
            w = (int)((float)(this.rw - this.insetW) / this.scaling) + (int)((float)this.insetW / this.scaling);
            if ((float)x < (float)this.insetW / this.scaling) {
                x = (int)((float)this.insetW / this.scaling);
            }
            if ((float)y < (float)this.insetH / this.scaling) {
                y = 0;
            }
            y = (int)((float)topY - (float)(this.ry + this.rh) / this.scaling);
        } else if (this.displayRotation == 90) {
            y = (int)((float)(this.rx - this.insetW) / this.scaling);
            h = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = this.ry > this.insetW ? (int)((float)(this.ry - this.insetW) / this.scaling) : 0;
            w = (int)((float)this.rh / this.scaling);
        } else if (this.displayRotation == 270) {
            w = (int)((float)(this.rh + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.ry + this.rh) / this.scaling);
            h = (int)((float)(this.rw + this.insetH) / this.scaling);
            y = topY - (int)((float)(this.rx + this.rw) / this.scaling);
            if (x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        } else if (this.displayRotation == 180) {
            h = (int)((float)(this.rh + this.insetH) / this.scaling) + this.insetH;
            y = (int)((float)(this.ry - this.insetH) / this.scaling);
            w = (int)((float)(this.rw + this.insetW) / this.scaling);
            x = topX - (int)((float)(this.rx - this.insetW) / this.scaling);
            if ((x -= w) < 0 || x < this.insetH) {
                x = 0;
                w += this.insetH;
            }
            if (y < this.insetW) {
                y = 0;
                h += this.insetW;
            }
        }
        if (this.isAccelerated() || this.scaling >= 2.0f) {
            int dx1 = this.pageData.getScaledCropBoxX(this.pageNumber);
            int dy1 = this.pageData.getScaledCropBoxY(this.pageNumber);
            gap = 2;
            userAnnot = dx1 != 0 || dy1 != 0 ? new Rectangle(x + (int)((float)dx1 / this.scaling), y + (int)((float)dy1 / this.scaling), w, h) : new Rectangle(x, y, w + (gap + gap), h + (gap + gap));
        } else {
            userAnnot = null;
        }
        if (this.displayView != 1 && this.message) {
            this.message = true;
            System.out.println("SingleDisplay fast scrolling");
            userAnnot = null;
        }
        return userAnnot;
    }

    public Rectangle drawPage(AffineTransform viewScaling, AffineTransform displayScaling, int pageUsedForTransform) {
        Rectangle actualBox = null;
        if (displayScaling != null && this.currentDisplay != null) {
            if (this.scaling < 2.0f && this.oldScaling > 2.0f) {
                this.useAcceleration = true;
            }
            if (this.useAcceleration || this.areas != null) {
                this.screenNeedsRedrawing = true;
            }
            boolean canDrawAccelerated = false;
            if (this.useAcceleration && !this.overRideAcceleration && this.scaling < 2.0f) {
                canDrawAccelerated = this.testAcceleratedRendering();
            } else {
                this.useAcceleration = false;
            }
            Rectangle userAnnot = null;
            if (!this.isAccelerated()) {
                userAnnot = this.calcVisibleArea((int)((float)this.topH / this.scaling), (int)((float)this.topW / this.scaling));
            }
            this.currentDisplay.setScalingValues(this.cropX, this.cropH + this.cropY, this.scaling);
            this.g2.transform(displayScaling);
            if (DynamicVectorRenderer.debugPaint) {
                System.err.println("accelerate or redraw");
            }
            if (canDrawAccelerated) {
                Graphics2D gBB = (Graphics2D)this.backBuffer.getGraphics();
                if (this.screenNeedsRedrawing) {
                    gBB.setColor(this.currentDisplay.getBackgroundColor());
                    gBB.fill(new Rectangle(0, 0, this.backBuffer.getWidth(), this.backBuffer.getHeight()));
                    this.currentDisplay.setOptimsePainting(true);
                    gBB.setTransform(displayScaling);
                    this.setDisplacementOnG2(gBB);
                    actualBox = this.currentDisplay.paint(gBB, this.areas, viewScaling, userAnnot, false, true);
                    this.drawSpreadPages(gBB, viewScaling, userAnnot, false);
                    this.screenNeedsRedrawing = false;
                }
                gBB.dispose();
                if (this.backBuffer != null) {
                    AffineTransform affBefore = this.g2.getTransform();
                    this.g2.setTransform(this.rawAf);
                    this.g2.drawImage(this.backBuffer, this.insetW, this.insetH, this.pdf);
                    this.g2.setTransform(affBefore);
                    actualBox = this.currentDisplay.paint(this.g2, this.areas, viewScaling, userAnnot, true, true);
                    this.drawSpreadPages(this.g2, viewScaling, userAnnot, true);
                }
            } else {
                if (DynamicVectorRenderer.debugPaint) {
                    System.err.println("standard paint called ");
                }
                this.g2.clip(new Rectangle((int)(this.cropX / (double)this.scaling), (int)(this.cropY / (double)this.scaling), (int)((float)this.topW / this.scaling), (int)((float)this.topH / this.scaling)));
                this.currentDisplay.setOptimsePainting(false);
                actualBox = this.currentDisplay.paint(this.g2, this.areas, viewScaling, userAnnot, false, true);
                this.drawSpreadPages(this.g2, viewScaling, userAnnot, false);
            }
            this.oldScaling = this.scaling;
            this.oldRotation = this.displayRotation;
        }
        return actualBox;
    }

    private void drawSpreadPages(Graphics2D g2, AffineTransform viewScaling, Rectangle userAnnot, boolean flag) {
        if (this.currentXOffset > 0) {
            int[] currentOffset = this.offsets.get();
            int count = currentOffset.length;
            int currentValue = 0;
            int i = 0;
            while (i < count) {
                currentValue = currentOffset[i];
                if (currentValue > 0) {
                    DynamicVectorRenderer renderer = (DynamicVectorRenderer)this.newPages.get(new Integer(currentValue));
                    g2.setClip(null);
                    g2.translate(currentValue, 0);
                    if (renderer != null) {
                        renderer.paint(g2, this.areas, viewScaling, userAnnot, flag, true);
                    }
                    g2.translate(-currentValue, 0);
                }
                ++i;
            }
        }
    }

    public void setup(boolean useAcceleration, PageOffsets currentOffset, PdfDecoder pdf) {
        this.useAcceleration = useAcceleration;
        this.currentOffset = currentOffset;
        this.pdf = pdf;
        this.overRideAcceleration = false;
    }

    public int getXCordForPage(int page) {
        return this.xReached[page] + this.insetW;
    }

    public int getYCordForPage(int page) {
        return this.yReached[page] + this.insetH;
    }

    public int getStartPage() {
        return this.startViewPage;
    }

    public int getEndPage() {
        return this.endViewPage;
    }

    public boolean isDecoding() {
        return this.running;
    }

    public void setThumbnailsDrawing(boolean b) {
        this.thumbnailsRunning = b;
    }

    public void setThumbnailPanel(GUIThumbnailPanel thumbnails) {
        this.thumbnails = thumbnails;
    }

    public void setScaling(float scaling) {
        this.scaling = scaling;
        this.pageData.setScalingValue(scaling);
    }
}

