/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class Save
extends JComponent {
    protected JTextField startPage = new JTextField();
    protected JTextField endPage = new JTextField();
    protected JTextField rootDir = new JTextField();
    protected Object[] scales = new Object[]{"10", "25", "50", "75", "100"};
    protected JComboBox scaling = new JComboBox<Object>(this.scales);
    protected JLabel scalingLabel = new JLabel();
    protected JLabel rootFilesLabel = new JLabel();
    protected JButton changeButton = new JButton();
    protected JLabel endLabel = new JLabel();
    protected JLabel startLabel = new JLabel();
    protected JLabel pageRangeLabel = new JLabel();
    protected String root_dir;
    protected int end_page;
    protected int currentPage;
    protected JLabel optionsForFilesLabel = new JLabel();

    public Save(final String root_dir, int end_page, int currentPage) {
        this.currentPage = currentPage;
        this.root_dir = root_dir;
        this.end_page = end_page;
        this.scalingLabel.setFont(new Font("Dialog", 1, 14));
        this.scalingLabel.setText(String.valueOf(Messages.getMessage((String)"PdfViewerOption.Scaling")) + "\n");
        this.scaling.setSelectedItem("100");
        this.rootFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.rootFilesLabel.setDisplayedMnemonic('0');
        this.rootFilesLabel.setText(Messages.getMessage((String)"PdfViewerOption.RootDir"));
        this.rootDir.setText(root_dir);
        this.changeButton.setText(Messages.getMessage((String)"PdfViewerOption.Browse"));
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(root_dir);
                chooser.setFileSelectionMode(0);
                String[] png = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
                chooser.addChoosableFileFilter(new FileFilterer(png, "Images (Tiff, Jpeg,Png)"));
                chooser.setFileSelectionMode(1);
                int state = chooser.showOpenDialog(null);
                File file = chooser.getSelectedFile();
                if (file != null && state == 0) {
                    Save.this.rootDir.setText(file.getAbsolutePath());
                }
            }
        });
        this.optionsForFilesLabel.setText(Messages.getMessage((String)"PdfViewerOption.Output"));
        this.optionsForFilesLabel.setFont(new Font("Dialog", 1, 14));
        this.optionsForFilesLabel.setDisplayedMnemonic('0');
        this.pageRangeLabel.setText(Messages.getMessage((String)"PdfViewerOption.PageRange"));
        this.pageRangeLabel.setFont(new Font("Dialog", 1, 14));
        this.pageRangeLabel.setDisplayedMnemonic('0');
        this.startLabel.setText(Messages.getMessage((String)"PdfViewerOption.StartPage"));
        this.endLabel.setText(Messages.getMessage((String)"PdfViewerOption.EndPage"));
        this.startPage.setText("1");
        this.endPage.setText("" + end_page);
    }

    public final int getScaling() {
        return Integer.parseInt((String)this.scaling.getSelectedItem());
    }

    public int display(Component c, String title) {
        this.setSize(400, 200);
        JPanel popupPanel = new JPanel();
        popupPanel.setLayout(new BorderLayout());
        popupPanel.add((Component)this, "Center");
        popupPanel.setSize(400, 200);
        Object[] options = new Object[]{Messages.getMessage((String)"PdfMessage.Ok"), Messages.getMessage((String)"PdfMessage.Cancel")};
        int n = JOptionPane.showOptionDialog(c, popupPanel, title, -1, -1, null, options, options[0]);
        return n;
    }

    public final int getStartPage() {
        int page = -1;
        try {
            page = Integer.parseInt(this.startPage.getText());
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " in exporting"));
            JOptionPane.showMessageDialog(this, Messages.getMessage((String)"PdfViewerError.InvalidSyntax"));
        }
        if (page < 1) {
            JOptionPane.showMessageDialog(this, Messages.getMessage((String)"PdfViewerError.NegativePageValue"));
        }
        if (page > this.end_page) {
            JOptionPane.showMessageDialog(this, String.valueOf(Messages.getMessage((String)"PdfViewerText.Page")) + " " + page + " " + Messages.getMessage((String)"PdfViewerError.OutOfBounds") + " " + Messages.getMessage((String)"PdfViewerText.PageCount") + " " + this.end_page);
            page = -1;
        }
        return page;
    }

    public final String getRootDir() {
        return this.rootDir.getText();
    }

    public final int getEndPage() {
        int page = -1;
        try {
            page = Integer.parseInt(this.endPage.getText());
        }
        catch (Exception e) {
            LogWriter.writeLog((String)("Exception " + e + " in exporting"));
            JOptionPane.showMessageDialog(this, Messages.getMessage((String)"PdfViewerError.InvalidSyntax"));
        }
        if (page < 1) {
            JOptionPane.showMessageDialog(this, Messages.getMessage((String)"PdfViewerError.NegativePageValue"));
        }
        if (page > this.end_page) {
            JOptionPane.showMessageDialog(this, String.valueOf(Messages.getMessage((String)"PdfViewerText.Page")) + " " + page + " " + Messages.getMessage((String)"PdfViewerError.OutOfBounds") + " " + Messages.getMessage((String)"PdfViewerText.PageCount") + " " + this.end_page);
            page = -1;
        }
        return page;
    }

    public final Dimension getSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 330);
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

