/*
 * Decompiled with CFR 0.152.
 */
package res;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;
import res.Config;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DeviceID {
    private int querSumme;
    private long zeit;
    private Config CONFIG;
    private String FILE;
    private String Error = "";
    private boolean noMACCheck = true;

    public DeviceID(Config conf, boolean neu, boolean noMacCheck) {
        this.CONFIG = conf;
        this.FILE = String.valueOf(this.CONFIG.getUserDataDir()) + ".pid";
        this.zeit = System.currentTimeMillis();
        this.noMACCheck = noMacCheck;
        String code = String.valueOf(System.getProperty("os.name")) + System.getProperty("os.arch") + System.getProperty("os.version") + System.getProperty("user.name");
        int x = code.hashCode();
        if (x < 0) {
            x *= -1;
        }
        this.querSumme = 0;
        while (x != 0) {
            this.querSumme += x % 10;
            x /= 10;
        }
        this.querSumme *= 1000;
        File f = new File(this.FILE);
        if (!f.exists() || neu) {
            this.createFile(f);
        }
    }

    private void createFile(File f) {
        try {
            f.createNewFile();
            f.setLastModified(this.zeit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.zeit = f.lastModified();
        String check = this.format(DeviceID.MD5("" + this.zeit));
        try {
            String guid = this.getGUID(true);
            String ln = String.valueOf(check) + " " + guid + " " + this.getMacAddresses();
            ln = new BASE64Encoder().encodeBuffer(ln.getBytes());
            FileOutputStream out = new FileOutputStream(f);
            int i = 0;
            while (i < ln.length()) {
                out.write((byte)ln.charAt(i));
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.Error = e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.Error = e.getMessage();
        }
        f.setLastModified(this.zeit + (long)this.querSumme);
    }

    public String getID() {
        File f = new File(this.FILE);
        long zeit = f.lastModified();
        try {
            byte zeichen;
            String ln = "";
            FileInputStream in = new FileInputStream(f);
            do {
                zeichen = (byte)in.read();
                ln = String.valueOf(ln) + (char)zeichen;
            } while (zeichen != -1);
            in.close();
            if (ln.length() >= 73) {
                byte[] decoded = new BASE64Decoder().decodeBuffer(ln);
                ln = new String(decoded);
                String check = ln.substring(0, 36);
                String guid = ln.substring(37, 73);
                String macs = "";
                if (ln.length() > 73) {
                    macs = ln.substring(74);
                }
                if (this.noMACCheck) {
                    if (this.CONFIG.DEVELOP) {
                        System.out.println("MAC wird nicht gepr\u00fcft");
                    }
                    return guid;
                }
                if (check.equals(this.format(DeviceID.MD5("" + (zeit - (long)this.querSumme))))) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        String mac = this.getMACAddress(NetworkInterface.getByInetAddress(InetAddress.getLocalHost()));
                        if (macs.indexOf(mac) > -1) {
                            return guid;
                        }
                        this.createFile(new File(this.FILE));
                        return this.getID();
                    }
                    return guid;
                }
                return "ERROR_CHECK (" + this.Error + ")";
            }
            this.createFile(new File(this.FILE));
            return this.getID();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "ERROR_NOFILE (" + e.getMessage() + ")";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "ERROR_IO (" + e.getMessage() + ")";
        }
    }

    private String format(String str) {
        str = str.toUpperCase();
        StringBuffer sb = new StringBuffer();
        sb.append(str.substring(0, 8));
        sb.append("-");
        sb.append(str.substring(8, 12));
        sb.append("-");
        sb.append(str.substring(12, 16));
        sb.append("-");
        sb.append(str.substring(16, 20));
        sb.append("-");
        sb.append(str.substring(20));
        return sb.toString();
    }

    private String formatMAC(String str) {
        if ((str = str.toUpperCase()).length() == 12) {
            StringBuffer sb = new StringBuffer();
            sb.append(str.substring(0, 2));
            sb.append("-");
            sb.append(str.substring(2, 4));
            sb.append("-");
            sb.append(str.substring(4, 6));
            sb.append("-");
            sb.append(str.substring(6, 8));
            sb.append("-");
            sb.append(str.substring(8, 10));
            sb.append("-");
            sb.append(str.substring(10));
            return sb.toString();
        }
        if (this.CONFIG.isDebug()) {
            System.err.println("formatMAC: " + str + " (" + str.length() + ")");
        }
        return "";
    }

    private String getGUID(boolean secure) {
        StringBuffer sb = new StringBuffer();
        try {
            long time = System.currentTimeMillis();
            long rand = 0L;
            SecureRandom mySecureRand = new SecureRandom();
            long secureInitializer = mySecureRand.nextLong();
            Random myRand = new Random(secureInitializer);
            String hostname = "";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            rand = secure ? mySecureRand.nextLong() : myRand.nextLong();
            sb.append(hostname);
            sb.append(":");
            sb.append(Long.toString(time));
            sb.append(":");
            sb.append(Long.toString(rand));
            return this.format(DeviceID.MD5(sb.toString()));
        }
        catch (Exception e) {
            System.err.println("Error:" + e);
            return "ERROR_GUID (" + e.getMessage() + ")";
        }
    }

    public static String MD5(String in) {
        String plainText = in;
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest mdAlgorithm = MessageDigest.getInstance("MD5");
            mdAlgorithm.update(plainText.getBytes());
            byte[] digest = mdAlgorithm.digest();
            int i = 0;
            while (i < digest.length) {
                plainText = Integer.toHexString(0xFF & digest[i]);
                if (plainText.length() < 2) {
                    plainText = "0" + plainText;
                }
                hexString.append(plainText);
                ++i;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return hexString.toString();
    }

    public String getMACAddress(NetworkInterface iface) {
        block8: {
            String mac = "";
            try {
                byte[] hardwareAddress = iface.getHardwareAddress();
                if (hardwareAddress == null) break block8;
                int i = 0;
                while (i < hardwareAddress.length) {
                    try {
                        int zahl = Integer.parseInt(String.valueOf(hardwareAddress[i]));
                        if (zahl < 0) {
                            zahl += 256;
                        }
                        mac = zahl < 16 ? String.valueOf(mac) + "0" + Integer.toHexString(zahl) : String.valueOf(mac) + Integer.toHexString(zahl);
                    }
                    catch (NumberFormatException nfe) {
                        mac = String.valueOf(mac) + hardwareAddress[i];
                    }
                    ++i;
                }
                if (!mac.equals("") && mac.length() == 12) {
                    String tmp = this.formatMAC(mac);
                    if (this.CONFIG.isDebug()) {
                        System.out.println(iface + " MAC: " + tmp);
                    }
                    return tmp;
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String getMacAddresses() {
        String result = "";
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface nextIface = interfaces.nextElement();
                    String mac = this.getMACAddress(nextIface);
                    if (mac.equals("")) continue;
                    result = String.valueOf(result) + mac + ",";
                }
                if (result.length() > 1) {
                    result = result.substring(0, result.length() - 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

