/*
 * Decompiled with CFR 0.152.
 */
package res;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdom.Element;
import org.jdom.Namespace;

public class Produkt {
    String ID;
    String UPDTIME;
    String CRTIME;
    String Status;
    String Klasse;
    String Gruppe;
    String Untergruppe;
    String Art;
    String Bezeichnung = "";
    String Beschreibung;
    String Stichworte;
    String Liz_Von;
    String Liz_Bis;
    String Recht_View;
    String Recht_Print;
    String Recht_CopyPaste;
    String Dateiname;
    String Dateipfad;
    String Sprache_ID;
    String Sprach_Code;
    String URL;
    String Produktnummer;
    String Produktnummer_B;
    String Produktnummer_C;
    String Produktnummer_D;
    String Produktnummer_E;
    String Revision;
    String Revision_Datum;
    String Revision_Info;
    String isArchiv = "";
    String Dateiname_Original;
    String Dateierweiterung_Original;
    String Muster_Produkt_Bezeichnung;
    String Jahr;
    String Klasse_Sprach_Code;
    String Gruppe_Sprach_Code;
    String Untergruppe_Sprach_Code;

    public Produkt(Element Norm, Namespace ns, String Muster_Produkt_Bezeichnung) {
        this.Muster_Produkt_Bezeichnung = Muster_Produkt_Bezeichnung;
        this.ID = Norm.getChildText("ID", ns);
        this.UPDTIME = Norm.getChildText("UPDTIME", ns);
        this.CRTIME = Norm.getChildText("CRTIME", ns);
        this.Status = Norm.getChildText("Status", ns);
        this.Klasse = Norm.getChildText("Klasse", ns);
        this.Gruppe = Norm.getChildText("Gruppe", ns);
        this.Untergruppe = Norm.getChildText("Untergruppe", ns);
        this.Art = Norm.getChildText("Art", ns);
        this.Bezeichnung = Norm.getChildText("Bezeichnung", ns);
        if (this.Bezeichnung == null) {
            this.Bezeichnung = "";
        }
        this.Beschreibung = Norm.getChildText("Beschreibung", ns);
        this.Stichworte = Norm.getChildText("Stichworte", ns);
        this.Liz_Von = Norm.getChildText("Liz_Von", ns);
        this.Liz_Bis = Norm.getChildText("Liz_Bis", ns);
        this.Recht_View = Norm.getChildText("Recht_View", ns);
        this.Recht_Print = Norm.getChildText("Recht_Print", ns);
        this.Recht_CopyPaste = Norm.getChildText("Recht_CopyPaste", ns);
        this.Dateiname = Norm.getChildText("Dateiname", ns);
        this.Dateipfad = Norm.getChildText("Dateipfad", ns);
        this.Sprache_ID = Norm.getChildText("Sprache_ID", ns);
        this.Sprach_Code = Norm.getChildText("Sprach_Code", ns);
        this.URL = Norm.getChildText("URL", ns);
        this.Produktnummer = Norm.getChildText("Produktnummer", ns);
        if (this.Produktnummer == null) {
            this.Produktnummer = "";
        }
        this.Produktnummer_B = Norm.getChildText("Produktnummer_B", ns);
        this.Produktnummer_C = Norm.getChildText("Produktnummer_C", ns);
        this.Produktnummer_D = Norm.getChildText("Produktnummer_D", ns);
        this.Produktnummer_E = Norm.getChildText("Produktnummer_E", ns);
        this.Revision = Norm.getChildText("Revision", ns);
        this.Revision_Datum = Norm.getChildText("Revision_Datum", ns);
        this.Revision_Info = Norm.getChildText("Revision_Datum", ns);
        this.isArchiv = Norm.getChildText("isArchiv", ns);
        this.Jahr = Norm.getChildText("Jahr", ns);
        this.Klasse_Sprach_Code = Norm.getChildText("Klasse_Sprach_Code", ns);
        this.Gruppe_Sprach_Code = Norm.getChildText("Gruppe_Sprach_Code", ns);
        this.Untergruppe_Sprach_Code = Norm.getChildText("Untergruppe_Sprach_Code", ns);
        try {
            this.Dateiname_Original = Norm.getChildText("Dateiname_Original", ns);
            this.Dateierweiterung_Original = Norm.getChildText("Dateierweiterung_Original", ns);
        }
        catch (Exception e) {
            this.Dateiname_Original = "";
            this.Dateierweiterung_Original = "";
        }
    }

    public String getID() {
        return this.ID;
    }

    public String getUPDTIME() {
        return this.UPDTIME;
    }

    public String getCRTIME() {
        return this.CRTIME;
    }

    public String getStatus() {
        return this.Status;
    }

    public String getKlasse() {
        return this.Klasse;
    }

    public String getGruppe() {
        return this.Gruppe;
    }

    public String getUntergruppe() {
        return this.Untergruppe;
    }

    public String getArt() {
        return this.Art;
    }

    public String getBezeichnung() {
        return this.Bezeichnung;
    }

    public String getBeschreibung() {
        return this.Beschreibung;
    }

    public String getStichworte() {
        return this.Stichworte;
    }

    public String getLiz_Von() {
        Date d = new Date();
        try {
            d = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Von.substring(0, 10));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return df.format(d);
    }

    public String getLiz_Bis() {
        Date d = new Date();
        try {
            d = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Bis.substring(0, 10));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return df.format(d);
    }

    public String getDateiname() {
        return this.Dateiname;
    }

    public String getDateipfad() {
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return this.Dateipfad.replaceAll("\\\\", System.getProperty("file.separator"));
        }
        return this.Dateipfad;
    }

    public String getSprache_ID() {
        return this.Sprache_ID;
    }

    public String getSprach_Code() {
        return this.Sprach_Code;
    }

    public String getURL() {
        return this.URL;
    }

    public String getProduktnummer() {
        return this.Produktnummer;
    }

    public String getProduktnummer_B() {
        return this.Produktnummer_B;
    }

    public String getProduktnummer_C() {
        return this.Produktnummer_C;
    }

    public String getProduktnummer_D() {
        return this.Produktnummer_D;
    }

    public String getProduktnummer_E() {
        return this.Produktnummer_E;
    }

    public String getRevision() {
        return this.Revision;
    }

    public String getRevision_Datum() {
        Date d = new Date();
        try {
            d = new SimpleDateFormat("yyyy-MM-dd").parse(this.Revision_Datum.substring(0, 10));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        return df.format(d);
    }

    public String getRevision_Info() {
        return this.Revision_Info;
    }

    public boolean getRecht_View() {
        return this.Recht_View.equals("true");
    }

    public String getRecht_View_str() {
        return this.Recht_View;
    }

    public boolean getRecht_Print() {
        return this.Recht_Print.equals("true");
    }

    public String getRecht_Print_str() {
        return this.Recht_Print;
    }

    public boolean check_Recht_View() {
        try {
            Date now = new Date();
            Date von = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Von.substring(0, 10));
            Date bis = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Bis.substring(0, 10));
            return now.before(bis) && now.after(von) && this.getRecht_View();
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean check_Kulanz(int kulanz) {
        try {
            Date now = new Date();
            Date von = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Von.substring(0, 10));
            Date bis = new SimpleDateFormat("yyyy-MM-dd").parse(this.Liz_Bis.substring(0, 10));
            long einTag = 86400000L;
            bis = new Date(bis.getTime() + einTag * (long)kulanz);
            return now.before(bis) && now.after(von) && this.getRecht_View();
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean getRecht_CopyPaste() {
        return this.Recht_CopyPaste.equals("true");
    }

    public String getRecht_CopyPaste_str() {
        return this.Recht_CopyPaste;
    }

    public String toString() {
        try {
            String tmp = this.Muster_Produkt_Bezeichnung;
            tmp = tmp.replaceAll("#Produktnummer", this.Produktnummer);
            tmp = tmp.replaceAll("#Bezeichnung", this.Bezeichnung);
            tmp = tmp.replaceAll("#Jahr", this.Jahr);
            return tmp;
        }
        catch (Exception e) {
            return String.valueOf(this.Produktnummer) + " (ERROR)";
        }
    }

    public String getInfo() {
        return String.valueOf(this.ID.substring(0, 8)) + "\t" + this.Produktnummer + " - " + this.Bezeichnung + "\t" + this.getLiz_Von() + "\t" + this.getLiz_Bis();
    }

    public boolean isArchived() {
        return this.isArchiv != null && !this.isArchiv.equals("0");
    }

    public String getDateiname_Original() {
        return this.Dateiname_Original;
    }

    public String getDateierweiterung_Original() {
        return this.Dateierweiterung_Original;
    }

    public String getKlasse_Sprach_Code() {
        return this.Klasse_Sprach_Code;
    }

    public String getGruppe_Sprach_Code() {
        return this.Gruppe_Sprach_Code;
    }

    public String getUntergruppe_Sprach_Code() {
        return this.Untergruppe_Sprach_Code;
    }
}

