/*
 * Decompiled with CFR 0.152.
 */
package res;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import res.Config;
import res.ZipArchiveExtractor;
import res.obj.Sprache;
import res.obj.redAnrede;
import res.obj.redBenutzerkonto;
import res.obj.redBerufstitel;
import res.obj.redLabel;
import res.obj.redLaender;
import res.obj.redLizenz_Client;
import res.obj.redLizenz_Vertrag;
import res.obj.redMenu;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WebService {
    private Config CONFIG = null;
    public String response_error = "";

    public WebService(Config Conf) {
        this.CONFIG = Conf;
    }

    private InputStream action(String service, String action, String xml) throws IOException {
        int c;
        String server = "http://" + this.CONFIG.getSoap_server() + "/" + this.CONFIG.getSoap_serverpfad() + service + ".asmx";
        String soapaction = "http://" + this.CONFIG.getSoap_namespace() + "/" + action;
        URL u = new URL(server);
        URLConnection uc = u.openConnection();
        HttpURLConnection connection = (HttpURLConnection)uc;
        if (this.CONFIG.isProxy_active()) {
            this.CONFIG.isProxy_useuser();
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Host", this.CONFIG.getSoap_server());
        connection.setRequestProperty("Content-Type", "application/soap+xml; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(soapaction.length()));
        String info = String.valueOf(this.CONFIG.getAPPNAME()) + "/" + this.CONFIG.getVERSION() + " OS:" + System.getProperty("os.name") + " Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ") Lang:" + this.CONFIG.getSprache();
        connection.setRequestProperty("User-Agent", info);
        OutputStreamWriter wout = new OutputStreamWriter(connection.getOutputStream());
        wout.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        wout.write("<soap12:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap12=\"http://www.w3.org/2003/05/soap-envelope\">\r\n");
        wout.write("<soap12:Body>\r\n");
        wout.write(xml);
        wout.write("</soap12:Body>\r\n");
        wout.write("</soap12:Envelope>\r\n");
        ((Writer)wout).flush();
        ((Writer)wout).close();
        if (System.getProperty("superdebug", "0").equals("1")) {
            System.out.println("WS-Action: " + action);
            System.out.println(xml);
        }
        this.response_error = "";
        if (this.CONFIG.isDebug() && connection.getResponseCode() != 200) {
            this.response_error = String.valueOf(action) + ": " + connection.getResponseCode() + ": " + connection.getResponseMessage();
            System.out.println(this.response_error);
            return null;
        }
        InputStream in = connection.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        in.close();
        out.close();
        connection.disconnect();
        if (System.getProperty("superdebug", "0").equals("1")) {
            ByteArrayInputStream fis = new ByteArrayInputStream(out.toByteArray());
            FileOutputStream fostmp = new FileOutputStream(new File("WS-" + service + "_" + action + ".xml"));
            byte[] buftmp = new byte[1024];
            int itmp = 0;
            while ((itmp = fis.read(buftmp)) != -1) {
                fostmp.write(buftmp, 0, itmp);
            }
            fostmp.close();
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public String echo() {
        return this.echo("srDefault");
    }

    public String echo(String script) {
        SAXBuilder builder = new SAXBuilder();
        try {
            InputStream is = this.action(script, "ECHO", "<ECHO xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\" />\r\n");
            Document doc = builder.build(is);
            is.close();
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("ECHOResponse", own);
            return Response.getChildText("ECHOResult", own);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public String[] deleteMyDevice_ID(String Benutzer, String Passwort, String Device_ID) {
        String[] res = new String[]{"ERROR", "", ""};
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<deleteMyDevice_ID xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername>" + Benutzer + "</Benutzername>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(Passwort) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + Device_ID + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "</deleteMyDevice_ID>\r\n";
            InputStream is = this.action("srBenutzerkonto", "deleteMyDevice_ID", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("deleteMyDevice_IDResponse", own);
            res[0] = Response.getChildText("deleteMyDevice_IDResult", own);
            res[1] = Response.getChildText("returnLogIn_Result", own);
            res[2] = Response.getChildText("returnFehler", own);
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = "IOException";
            res[2] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = "JDOMException";
            res[2] = e.getMessage();
        }
        return res;
    }

    public Object[] getMyDevice_IDs(String Benutzer, String Passwort) {
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<getMyDevice_IDs xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername>" + Benutzer + "</Benutzername>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(Passwort) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "</getMyDevice_IDs>\r\n";
            InputStream is = this.action("srBenutzerkonto", "getMyDevice_IDs", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("getMyDevice_IDsResponse", own);
            Element result = Response.getChild("getMyDevice_IDsResult", own);
            if (Response.getChildText("returnLogIn_Result", own).equals("OK")) {
                Element diffgram = result.getChild("diffgram", diffgr);
                Element NewDataSet = diffgram.getChild("NewDataSet");
                List clientlist = NewDataSet.getChildren("redLizenz_Client");
                Iterator client = clientlist.iterator();
                Object[] res = new Object[clientlist.size() + 1];
                res[0] = Response.getChildText("returnLogIn_Result", own);
                int i = 1;
                while (client.hasNext()) {
                    redLizenz_Client lc = new redLizenz_Client((Element)client.next());
                    res[i] = lc;
                    ++i;
                }
                is.close();
                return res;
            }
            Object[] res = new Object[]{"ERROR", Response.getChildText("returnLogIn_Result", own), Response.getChildText("returnFehler", own)};
            return res;
        }
        catch (IOException e) {
            Object[] res = new Object[]{"ERROR", "IOException", e.getMessage()};
            return res;
        }
        catch (JDOMException e) {
            Object[] res = new Object[]{"ERROR", "JDOMException", e.getMessage()};
            return res;
        }
        catch (Exception e) {
            Object[] res = new Object[]{"ERROR", "Exception", e.getMessage()};
            return res;
        }
    }

    public String[] addEvent(String Eventbezeichnung, String Eventbeschreibung, String[] dynData) {
        String[] res = new String[2];
        try {
            SAXBuilder builder = new SAXBuilder();
            String search = "";
            String xml = "<addEvent xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Anwendungsname>" + this.CONFIG.getAPPNAME() + " / " + this.CONFIG.getVERSION() + "</Anwendungsname>\r\n";
            xml = String.valueOf(xml) + "<Eventbezeichnung>" + Eventbezeichnung + "</Eventbezeichnung>\r\n";
            xml = String.valueOf(xml) + "<Eventbeschreibung>" + Eventbeschreibung + "</Eventbeschreibung>\r\n";
            xml = this.CONFIG.isUserLoggedIn() ? String.valueOf(xml) + "<Benutzer_ID>" + this.CONFIG.getLICFILE().getID() + "</Benutzer_ID>\r\n" : String.valueOf(xml) + "<Benutzer_ID></Benutzer_ID>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "<Search_String>" + search + "</Search_String>\r\n";
            int z = 1;
            while (z <= dynData.length) {
                xml = String.valueOf(xml) + "<dynData_" + z + ">" + dynData[z - 1] + "</dynData_" + z + ">\r\n";
                ++z;
            }
            while (z <= 10) {
                xml = String.valueOf(xml) + "<dynData_" + z + "></dynData_" + z + ">\r\n";
                ++z;
            }
            xml = String.valueOf(xml) + "</addEvent>\r\n";
            InputStream is = this.action("srBenutzerkonto", "addEvent", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("addEventResponse", own);
            res[0] = Response.getChildText("addEventResult", own);
            res[1] = Response.getChildText("returnFehler", own);
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] getVersion() {
        String[] res = new String[3];
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<getVersion_Info_SecureReader xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<aOS>" + System.getProperty("os.name").replaceAll(" ", "_") + "</aOS>\r\n";
            xml = String.valueOf(xml) + "<aCurrent_Version>" + this.CONFIG.getVERSION() + "</aCurrent_Version>\r\n";
            xml = String.valueOf(xml) + "</getVersion_Info_SecureReader>\r\n";
            InputStream is = this.action("srStammdaten", "getVersion_Info_SecureReader", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Namespace xsd = Namespace.getNamespace((String)"http://www.redM.ch/Types/xsd");
            Element root = doc.getRootElement();
            Element response = root.getChild("Body", soap).getChild("getVersion_Info_SecureReaderResponse", own);
            Element result = response.getChild("getVersion_Info_SecureReaderResult", own);
            Element dff = result.getChild("diffgram", diffgr);
            Element DataSet = dff.getChild("SecureReader_Versions_Info_DataSet", xsd);
            Element Version2 = DataSet.getChild("Version", xsd);
            Element Info = DataSet.getChild("Info", xsd);
            String ver = String.valueOf(Version2.getChildText("Major", xsd)) + ".";
            ver = String.valueOf(ver) + Version2.getChildText("Minor", xsd) + ".";
            ver = String.valueOf(ver) + Version2.getChildText("Release", xsd) + ".";
            res[0] = ver = String.valueOf(ver) + Version2.getChildText("Build", xsd);
            res[1] = Info.getChildText("URL", xsd);
            res[2] = response.getChildText("returnFehler", own);
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = "IOException";
            res[2] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = "JDOMException";
            res[2] = e.getMessage();
        }
        return res;
    }

    public void getLabels() {
        try {
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + "Labels.xml");
            File old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + "Labels.xml");
            if (old.exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            String xml = "<getLabelsForSecureReader xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "</getLabelsForSecureReader>\r\n";
            is = this.action("srStammdaten", "getLabelsForSecureReader", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Element root = doc.getRootElement();
            Element response = root.getChild("Body", soap).getChild("getLabelsForSecureReaderResponse", own);
            Element result = response.getChild("getLabelsForSecureReaderResult", own);
            Element dff = result.getChild("diffgram", diffgr);
            Element DataSet = dff.getChild("NewDataSet");
            List labellist = DataSet.getChildren("redLabel");
            Iterator labels = labellist.iterator();
            Object[] res = new Object[labellist.size()];
            FileWriter fw = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            bw.write("<redM_Labels_DataSet xmlns=\"http://www.redM.ch/Types/redM_Labels.xsd\">");
            int i = 0;
            while (labels.hasNext()) {
                redLabel l = new redLabel((Element)labels.next());
                bw.write("<Labels>");
                bw.write("<Key>" + l.getSchluessel() + "</Key>");
                bw.write("<Value>" + WebService.getEncodedString(l.getWert(), "ISO-8859-1") + "</Value>");
                bw.write("<Sprache_ID>" + l.getID_Sprache() + "</Sprache_ID>");
                bw.write("</Labels>");
                res[i] = l;
                ++i;
            }
            bw.write("</redM_Labels_DataSet>");
            is.close();
            bw.close();
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object[] getAnreden(boolean download) {
        try {
            File old;
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + this.CONFIG.getProvider() + "Anreden.xml");
            if (!f.exists() || download) {
                f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + "Anreden.xml");
            }
            if ((old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + "Anreden.xml")).exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            if (download || !f.exists()) {
                String xml = "<getAnreden xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
                xml = String.valueOf(xml) + "<aID_Sprache>" + this.CONFIG.getSprache() + "</aID_Sprache>\r\n";
                xml = String.valueOf(xml) + "</getAnreden>\r\n";
                is = this.action("srStammdaten", "getAnreden", xml);
                FileOutputStream fostmp = new FileOutputStream(f);
                byte[] buftmp = new byte[1024];
                int itmp = 0;
                while ((itmp = is.read(buftmp)) != -1) {
                    fostmp.write(buftmp, 0, itmp);
                }
                fostmp.close();
                is.reset();
            } else {
                is = new FileInputStream(f);
            }
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("getAnredenResponse", own);
            Element result = Response.getChild("getAnredenResult", own);
            Element diffgram = result.getChild("diffgram", diffgr);
            Element NewDataSet = diffgram.getChild("NewDataSet");
            String fehler = Response.getChildText("returnFehler", own);
            if (fehler.equals("")) {
                List anredenlist = NewDataSet.getChildren("redAnrede");
                Iterator anreden = anredenlist.iterator();
                Vector<redAnrede> anrede = new Vector<redAnrede>();
                while (anreden.hasNext()) {
                    redAnrede a = new redAnrede((Element)anreden.next());
                    if (!a.getID_Sprache().equals(this.CONFIG.getSprache())) continue;
                    anrede.add(a);
                }
                is.close();
                return anrede.toArray();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (JDOMException e) {
            return null;
        }
    }

    public Object[] getLaender(boolean download) {
        try {
            File old;
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + this.CONFIG.getProvider() + "Laender.xml");
            if (!f.exists() || download) {
                f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + "Laender.xml");
            }
            if ((old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + "Laender.xml")).exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            if (download || !f.exists()) {
                String xml = "<getLaender xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
                xml = String.valueOf(xml) + "<aID_Sprache>" + this.CONFIG.getSprache() + "</aID_Sprache>\r\n";
                xml = String.valueOf(xml) + "</getLaender>\r\n";
                is = this.action("srStammdaten", "getLaender", xml);
                FileOutputStream fostmp = new FileOutputStream(f);
                byte[] buftmp = new byte[1024];
                int itmp = 0;
                while ((itmp = is.read(buftmp)) != -1) {
                    fostmp.write(buftmp, 0, itmp);
                }
                fostmp.close();
                is.reset();
            } else {
                is = new FileInputStream(f);
            }
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("getLaenderResponse", own);
            Element result = Response.getChild("getLaenderResult", own);
            Element diffgram = result.getChild("diffgram", diffgr);
            Element NewDataSet = diffgram.getChild("NewDataSet");
            String fehler = Response.getChildText("returnFehler", own);
            if (fehler.equals("")) {
                List laenderlist = NewDataSet.getChildren("redLaender");
                Iterator laender = laenderlist.iterator();
                Vector<redLaender> tmp = new Vector<redLaender>();
                while (laender.hasNext()) {
                    redLaender l = new redLaender((Element)laender.next());
                    if (l.getBezeichnung().equals("")) continue;
                    tmp.add(l);
                }
                is.close();
                return tmp.toArray();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (JDOMException e) {
            return null;
        }
    }

    public Object[] getBerufstitel(boolean download) {
        try {
            File old;
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + this.CONFIG.getProvider() + "Berufstitel.xml");
            if (!f.exists() || download) {
                f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + "Berufstitel.xml");
            }
            if ((old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + "Berufstitel.xml")).exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            if (download || !f.exists()) {
                String xml = "<getBerufstitel xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
                xml = String.valueOf(xml) + "<aID_Sprache>" + this.CONFIG.getSprache() + "</aID_Sprache>\r\n";
                xml = String.valueOf(xml) + "</getBerufstitel>\r\n";
                is = this.action("srStammdaten", "getBerufstitel", xml);
                FileOutputStream fostmp = new FileOutputStream(f);
                byte[] buftmp = new byte[1024];
                int itmp = 0;
                while ((itmp = is.read(buftmp)) != -1) {
                    fostmp.write(buftmp, 0, itmp);
                }
                fostmp.close();
                is.reset();
            } else {
                is = new FileInputStream(f);
            }
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("getBerufstitelResponse", own);
            Element result = Response.getChild("getBerufstitelResult", own);
            Element diffgram = result.getChild("diffgram", diffgr);
            Element NewDataSet = diffgram.getChild("NewDataSet");
            String fehler = Response.getChildText("returnFehler", own);
            if (fehler.equals("")) {
                try {
                    List titellist = NewDataSet.getChildren("redBerufstitel");
                    Iterator berufstitel = titellist.iterator();
                    Vector<redBerufstitel> titel = new Vector<redBerufstitel>();
                    while (berufstitel.hasNext()) {
                        redBerufstitel b = new redBerufstitel((Element)berufstitel.next());
                        if (!b.getID_Sprache().equals(this.CONFIG.getSprache())) continue;
                        titel.add(b);
                    }
                    is.close();
                    return titel.toArray();
                }
                catch (Exception e) {
                    return new Object[0];
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (JDOMException e) {
            return null;
        }
    }

    public boolean getHelpFile(String sprache) {
        String address = "http://" + this.CONFIG.getSoap_server() + "/" + this.CONFIG.getSoap_serverpfad() + "Downloads/Doku/Help_" + sprache + ".pdf";
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        String helpfile = this.CONFIG.getHelpFilePath(this.CONFIG.getDatenpfad_stammdaten(), sprache);
        boolean deletefile = false;
        try {
            try {
                int numRead;
                URL url = new URL(address);
                out = new BufferedOutputStream(new FileOutputStream(helpfile));
                conn = url.openConnection();
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    numWritten += (long)numRead;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                deletefile = true;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    if (deletefile) {
                        File f = new File(helpfile);
                        f.delete();
                    }
                    return true;
                }
                catch (IOException f) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (deletefile) {
                    File f = new File(helpfile);
                    f.delete();
                }
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public boolean getLuceneIndex() {
        String address = "http://" + this.CONFIG.getSoap_server() + "/" + this.CONFIG.getSoap_serverpfad() + "Downloads/Lucene/Index.zip";
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        try {
            try {
                int numRead;
                URL url = new URL(address);
                out = new BufferedOutputStream(new FileOutputStream(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + "Index.zip"));
                conn = url.openConnection();
                in = conn.getInputStream();
                byte[] buffer = new byte[1024];
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    numWritten += (long)numRead;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    WebService.deleteDir(new File(this.CONFIG.getLuceneDir(this.CONFIG.getDatenpfad_stammdaten())));
                    ZipArchiveExtractor zipex = new ZipArchiveExtractor();
                    File index = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + "Index.zip");
                    zipex.extractArchive(index, new File(this.CONFIG.getDatenpfad_stammdaten()));
                    index.deleteOnExit();
                    return true;
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                WebService.deleteDir(new File(this.CONFIG.getLuceneDir(this.CONFIG.getDatenpfad_stammdaten())));
                ZipArchiveExtractor zipex = new ZipArchiveExtractor();
                File index = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + "Index.zip");
                zipex.extractArchive(index, new File(this.CONFIG.getDatenpfad_stammdaten()));
                index.deleteOnExit();
                return true;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object[] getLinks(boolean download) {
        try {
            File old;
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + this.CONFIG.getProvider() + "Links.xml");
            if (!f.exists()) {
                f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + "Links.xml");
            }
            if ((old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + "Links.xml")).exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            if (download || !f.exists()) {
                if (!this.CONFIG.isOnline()) {
                    return new Object[0];
                }
                String xml = "<getLinks xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
                xml = String.valueOf(xml) + "<returnFehler></returnFehler>\r\n";
                xml = String.valueOf(xml) + "</getLinks>\r\n";
                is = this.action("srStammdaten", "getLinks", xml);
                FileOutputStream fostmp = new FileOutputStream(f);
                byte[] buftmp = new byte[1024];
                int itmp = 0;
                while ((itmp = is.read(buftmp)) != -1) {
                    fostmp.write(buftmp, 0, itmp);
                }
                fostmp.close();
                is.reset();
            } else {
                is = new FileInputStream(f);
            }
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Namespace nslinks = Namespace.getNamespace((String)"", (String)"http://www.redMSoftware.ch/Secure_Webservice/dsLinks.xsd");
            Element root = doc.getRootElement();
            Element response = root.getChild("Body", soap).getChild("getLinksResponse", own);
            Element result = response.getChild("getLinksResult", own);
            Element dff = result.getChild("diffgram", diffgr);
            Element DataSet = dff.getChild("dsLinks", nslinks);
            Object[] res = new Object[]{};
            if (DataSet != null) {
                List menulist = DataSet.getChildren("Menu", nslinks);
                Iterator menu = menulist.iterator();
                res = new Object[menulist.size()];
                int i = 0;
                while (menu.hasNext()) {
                    redMenu m = new redMenu((Element)menu.next(), nslinks);
                    res[i] = m;
                    ++i;
                }
            }
            is.close();
            return res;
        }
        catch (IOException e) {
            return new Object[0];
        }
        catch (JDOMException e) {
            return new Object[0];
        }
    }

    public Object[] searchLizenz_Vertrag() throws IOException, JDOMException {
        Object[] res;
        SAXBuilder builder = new SAXBuilder();
        String xml = "<searchLizenz_Vertrag xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
        xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
        xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
        xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
        xml = String.valueOf(xml) + "<Email_to_match_Pattern>" + this.CONFIG.getLICFILE().getBenutzername() + "</Email_to_match_Pattern>\r\n";
        xml = String.valueOf(xml) + "<TCPIP_to_match_Pattern>auto</TCPIP_to_match_Pattern>\r\n";
        xml = String.valueOf(xml) + "<Status>aktiv</Status>\r\n";
        xml = String.valueOf(xml) + "</searchLizenz_Vertrag>\r\n";
        InputStream is = this.action("srLizenz", "searchLizenz_Vertrag", xml);
        Document doc = builder.build(is);
        Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
        Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
        Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
        Element root = doc.getRootElement();
        Element Body = root.getChild("Body", soap);
        Element result = Body.getChild("searchLizenz_VertragResponse", own).getChild("searchLizenz_VertragResult", own);
        Element diffgram = result.getChild("diffgram", diffgr);
        Element DocumentElement = diffgram.getChild("DocumentElement");
        if (DocumentElement == null) {
            res = new Object[]{Body.getChild("searchLizenz_VertragResponse", own).getChildText("returnLogIn_Result", own)};
        } else {
            List vertraglist = DocumentElement.getChildren("redLizenz_Vertrag");
            Iterator vertrag = vertraglist.iterator();
            res = new Object[vertraglist.size() + 1];
            res[0] = Body.getChild("searchLizenz_VertragResponse", own).getChildText("returnLogIn_Result", own);
            int i = 1;
            while (vertrag.hasNext()) {
                redLizenz_Vertrag v = new redLizenz_Vertrag((Element)vertrag.next(), diffgr);
                res[i] = v;
                ++i;
            }
            is.close();
        }
        return res;
    }

    public String[] getLizenzdatei(String name, String passwort, String device) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        String xml = "<getLizenzDatei xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
        xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + name + "</Benutzername_or_Kundennummer>\r\n";
        xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(passwort) + "</Passwort>\r\n";
        xml = String.valueOf(xml) + "<Device_ID>" + device + "</Device_ID>\r\n";
        xml = String.valueOf(xml) + "</getLizenzDatei>\r\n";
        InputStream is = this.action("srLizenz", "getLizenzDatei", xml);
        Document doc = builder.build(is);
        is.close();
        Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
        Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
        Element root = doc.getRootElement();
        Element Body = root.getChild("Body", soap);
        Element Response = Body.getChild("getLizenzDateiResponse", own);
        String LogIn_Result = Response.getChildText("returnLogIn_Result", own);
        String DateiResult = Response.getChildText("getLizenzDateiResult", own);
        String returnFehler = Response.getChildText("returnFehler", own);
        String datei = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "licfile.srl";
        String[] res = new String[2];
        if (LogIn_Result.equals("OK") && DateiResult != null) {
            byte[] decoded = new BASE64Decoder().decodeBuffer(DateiResult);
            ByteArrayInputStream in = new ByteArrayInputStream(decoded);
            FileOutputStream fos = new FileOutputStream(new File(datei));
            fos.write(decoded);
            fos.close();
            in.close();
            DateiResult = null;
            res[0] = "NOERROR";
            res[1] = datei;
        } else if (DateiResult != null) {
            res[0] = "ERROR";
            res[1] = "FileDownload";
        } else {
            res[0] = LogIn_Result;
            res[1] = returnFehler;
        }
        return res;
    }

    public String[] useLizenzNummer(String lizenznr) {
        String[] res = new String[2];
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<useLizenzNummer xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "<aLizenz_Nummer>" + lizenznr + "</aLizenz_Nummer>\r\n";
            xml = String.valueOf(xml) + "</useLizenzNummer>\r\n";
            if (System.getProperty("superdebug", "0").equals("1")) {
                System.out.println("WebService.useLizenzNummer");
                System.out.println(xml);
            }
            InputStream is = this.action("srLizenz", "useLizenzNummer", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("useLizenzNummerResponse", own);
            String antw = Response.getChildText("returnLizenz_Nummer_Registrierung", own);
            if (antw.equals("registriert")) {
                String datei = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "licfile.srl";
                byte[] decoded = new BASE64Decoder().decodeBuffer(Response.getChildText("useLizenzNummerResult", own));
                ByteArrayInputStream in = new ByteArrayInputStream(decoded);
                FileOutputStream fos = new FileOutputStream(new File(datei));
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = in.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
                fos.close();
                in.close();
                res[0] = "OK";
                res[1] = datei;
            } else {
                res[0] = Response.getChildText("returnLizenz_Nummer_Registrierung", own);
                res[1] = Response.getChildText("returnLogIn_Result", own);
            }
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] useLizenzNummer_next_free(String Lizenz_Vertrag_ID) {
        String[] res = new String[2];
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<useLizenzNummer_next_free xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "<aLizenz_Vertrag_ID>" + Lizenz_Vertrag_ID + "</aLizenz_Vertrag_ID>\r\n";
            xml = String.valueOf(xml) + "<aBenutzer_ID></aBenutzer_ID>\r\n";
            xml = String.valueOf(xml) + "</useLizenzNummer_next_free>\r\n";
            InputStream is = this.action("srLizenz", "useLizenzNummer_next_free", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("useLizenzNummer_next_freeResponse", own);
            String antw = Response.getChildText("returnLizenz_Nummer_Registrierung", own);
            if (antw.equals("registriert")) {
                String datei = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "licfile.srl";
                byte[] decoded = new BASE64Decoder().decodeBuffer(Response.getChildText("useLizenzNummer_next_freeResult", own));
                ByteArrayInputStream in = new ByteArrayInputStream(decoded);
                FileOutputStream fos = new FileOutputStream(new File(datei));
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = in.read(buf)) != -1) {
                    fos.write(buf, 0, i);
                }
                fos.close();
                in.close();
                res[0] = "OK";
                res[1] = datei;
            } else {
                res[0] = antw;
                res[1] = "";
            }
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] getDokument(String id) throws IOException, JDOMException {
        String xml = "<getDocument_Byte xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
        xml = String.valueOf(xml) + "<aProdukt_ID>" + id + "</aProdukt_ID>\r\n";
        xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
        xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
        xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
        xml = String.valueOf(xml) + "</getDocument_Byte>\r\n";
        InputStream is = this.action("srDokument", "getDocument_Byte", xml);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(is);
        Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
        Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
        Element root = doc.getRootElement();
        Element Body = root.getChild("Body", soap);
        Element Response = Body.getChild("getDocument_ByteResponse", own);
        String LogIn_Result = Response.getChildText("returnLogIn_Result", own);
        String returnFehler = Response.getChildText("returnFehler", own);
        String[] res = new String[2];
        if (returnFehler.equals("")) {
            String datei = System.getProperty("java.io.tmpdir");
            if (!datei.endsWith("\\")) {
                datei = String.valueOf(datei) + System.getProperty("file.separator");
            }
            datei = String.valueOf(datei) + Response.getChildText("returnFilename", own);
            byte[] decoded = new BASE64Decoder().decodeBuffer(Response.getChildText("getDocument_ByteResult", own));
            FileOutputStream fos = new FileOutputStream(new File(datei));
            fos.write(decoded);
            fos.close();
            res[0] = "OK";
            res[1] = datei;
        } else {
            res[0] = returnFehler;
            res[1] = LogIn_Result;
        }
        is.close();
        return res;
    }

    public String[] newBenutzerkonto(String xml) {
        SAXBuilder builder = new SAXBuilder();
        String[] res = new String[3];
        try {
            InputStream is = this.action("srBenutzerkonto", "newBenutzerkonto", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("newBenutzerkontoResponse", own);
            res[0] = response.getChildText("newBenutzerkontoResult", own);
            res[1] = response.getChildText("returnKundennummer", own);
            res[2] = response.getChildText("returnFehler", own);
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = "IOException";
            res[2] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = "JDOMException";
            res[2] = e.getMessage();
        }
        return res;
    }

    public String[] newBenutzerkonto_return_SRL(String xml) {
        SAXBuilder builder = new SAXBuilder();
        String[] res = new String[3];
        try {
            InputStream is = this.action("srBenutzerkonto", "newBenutzerkonto_return_SRL", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("newBenutzerkonto_return_SRLResponse", own);
            res[0] = response.getChildText("returnRegisterResult", own);
            if (res[0].equals("OK")) {
                String DateiResult = response.getChildText("newBenutzerkonto_return_SRLResult", own);
                String datei = String.valueOf(System.getProperty("java.io.tmpdir")) + System.getProperty("file.separator") + "licfile.srl";
                byte[] decoded = new BASE64Decoder().decodeBuffer(DateiResult);
                ByteArrayInputStream in = new ByteArrayInputStream(decoded);
                FileOutputStream fos = new FileOutputStream(new File(datei));
                fos.write(decoded);
                fos.close();
                in.close();
                DateiResult = null;
                res[1] = datei;
                res[2] = response.getChildText("returnKundennummer", own);
            } else {
                res[1] = response.getChildText("returnRegisterResult", own);
                res[2] = response.getChildText("returnFehler", own);
            }
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = "IOException";
            res[2] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = "JDOMException";
            res[2] = e.getMessage();
        }
        return res;
    }

    public String[] updateBenutzerkonto(String xml) {
        SAXBuilder builder = new SAXBuilder();
        String[] res = new String[2];
        try {
            InputStream is = this.action("srBenutzerkonto", "updateBenutzerkonto", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("updateBenutzerkontoResponse", own);
            res = new String[]{response.getChildText("updateBenutzerkontoResult", own), response.getChildText("returnFehler", own)};
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public Object[] getBenutzerkonto_light() {
        Object[] res = new Object[2];
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<getBenutzerkonto_light xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "<returnEmailadresse></returnEmailadresse>\r\n";
            xml = String.valueOf(xml) + "<returnAnrede_Code></returnAnrede_Code>\r\n";
            xml = String.valueOf(xml) + "<returnBerufstitel_Code></returnBerufstitel_Code>\r\n";
            xml = String.valueOf(xml) + "<returnName></returnName>\r\n";
            xml = String.valueOf(xml) + "<returnVorname></returnVorname>\r\n";
            xml = String.valueOf(xml) + "<returnFirma></returnFirma>\r\n";
            xml = String.valueOf(xml) + "<returnFirma1></returnFirma1>\r\n";
            xml = String.valueOf(xml) + "<returnStrasse></returnStrasse>\r\n";
            xml = String.valueOf(xml) + "<returnHausnummer></returnHausnummer>\r\n";
            xml = String.valueOf(xml) + "<returnPostfach></returnPostfach>\r\n";
            xml = String.valueOf(xml) + "<returnPLZ></returnPLZ>\r\n";
            xml = String.valueOf(xml) + "<returnOrt></returnOrt>\r\n";
            xml = String.valueOf(xml) + "<returnLand_Code></returnLand_Code>\r\n";
            xml = String.valueOf(xml) + "<returnTelefon></returnTelefon>\r\n";
            xml = String.valueOf(xml) + "<returnTelefon_Direkt></returnTelefon_Direkt>\r\n";
            xml = String.valueOf(xml) + "<returnTelefon_Mobil></returnTelefon_Mobil>\r\n";
            xml = String.valueOf(xml) + "<returnTelefon_Privat></returnTelefon_Privat>\r\n";
            xml = String.valueOf(xml) + "<returnZusatz></returnZusatz>\r\n";
            xml = String.valueOf(xml) + "<returnFax></returnFax>\r\n";
            xml = String.valueOf(xml) + "<returnSprach_Code></returnSprach_Code>\r\n";
            xml = String.valueOf(xml) + "<returnKundennummer></returnKundennummer>\r\n";
            xml = String.valueOf(xml) + "<returnFehler></returnFehler>\r\n";
            xml = String.valueOf(xml) + "</getBenutzerkonto_light>\r\n";
            InputStream is = this.action("srBenutzerkonto", "getBenutzerkonto_light", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("getBenutzerkonto_lightResponse", own);
            res[0] = response.getChildText("getBenutzerkonto_lightResult", own);
            if (((String)res[0]).equals("OK")) {
                res[1] = new redBenutzerkonto(response, own);
            }
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] resendValidationEmail() {
        String[] res = new String[2];
        try {
            SAXBuilder builder = new SAXBuilder();
            String xml = "<resendValidationEmail xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Benutzername_or_Kundennummer>" + this.CONFIG.getLICFILE().getKundennummer() + "</Benutzername_or_Kundennummer>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString(this.CONFIG.getLICFILE().getPasswort()) + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<Device_ID>" + this.CONFIG.getPID() + "</Device_ID>\r\n";
            xml = String.valueOf(xml) + "</resendValidationEmail>\r\n";
            InputStream is = this.action("srBenutzerkonto", "resendValidationEmail", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element Response = Body.getChild("resendValidationEmailResponse", own);
            res[0] = Response.getChildText("resendValidationEmailResult", own);
            res[1] = Response.getChildText("returnFehler", own);
            is.close();
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] addClient_Informations(String LogFile, String Kundennummer, String Kunde_Firma, String Kunde_Name, String Kunde_Vorname, String Kunde_Email) {
        SAXBuilder builder = new SAXBuilder();
        String[] res = new String[3];
        try {
            LogFile = new BASE64Encoder().encodeBuffer(LogFile.getBytes());
            String xml = "<addClient_Informations xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
            xml = String.valueOf(xml) + "<Reader_Benutzername>SecureReader</Reader_Benutzername>\r\n";
            xml = String.valueOf(xml) + "<Passwort>" + WebService.getXMLString("J6ghM057%ge") + "</Passwort>\r\n";
            xml = String.valueOf(xml) + "<LogFile>" + WebService.getXMLString(LogFile) + "</LogFile>\r\n";
            xml = String.valueOf(xml) + "<Kundennummer>" + WebService.getXMLString(Kundennummer) + "</Kundennummer>\r\n";
            xml = String.valueOf(xml) + "<Kunde_Firma>" + WebService.getXMLString(Kunde_Firma) + "</Kunde_Firma>\r\n";
            xml = String.valueOf(xml) + "<Kunde_Name>" + WebService.getXMLString(Kunde_Name) + "</Kunde_Name>\r\n";
            xml = String.valueOf(xml) + "<Kunde_Vorname>" + WebService.getXMLString(Kunde_Vorname) + "</Kunde_Vorname>\r\n";
            xml = String.valueOf(xml) + "<Kunde_Email>" + WebService.getXMLString(Kunde_Email) + "</Kunde_Email>\r\n";
            xml = String.valueOf(xml) + "</addClient_Informations>\r\n";
            System.out.println(xml);
            InputStream is = this.action("srBenutzerkonto", "addClient_Informations", xml);
            Document doc = builder.build(is);
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("addClient_InformationsResponse", own);
            res[0] = response.getChildText("addClient_InformationsResult", own);
            res[1] = response.getChildText("returnLogIn_Result", own);
            res[2] = response.getChildText("returnFehler", own);
        }
        catch (IOException e) {
            res[0] = "ERROR";
            res[1] = "IOException";
            res[2] = e.getMessage();
        }
        catch (JDOMException e) {
            res[0] = "ERROR";
            res[1] = "JDOMException";
            res[2] = e.getMessage();
        }
        return res;
    }

    public Vector getSprachen_per_Anwendung(String Art, boolean download) {
        Vector<Sprache> res = new Vector<Sprache>();
        try {
            File old;
            File f = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + this.CONFIG.getProvider() + Art + ".xml");
            if (!f.exists() || download) {
                f = new File(String.valueOf(this.CONFIG.getDatenpfad_stammdaten()) + this.CONFIG.getProvider() + Art + ".xml");
            }
            if ((old = new File(String.valueOf(this.CONFIG.getUserDataDir()) + this.CONFIG.getProvider() + Art + ".xml")).exists()) {
                old.delete();
            }
            InputStream is = null;
            SAXBuilder builder = new SAXBuilder();
            if (this.CONFIG.hasInternetConnection() && (download || !f.exists())) {
                String xml = "<getSprachen_per_Anwendung xmlns=\"http://" + this.CONFIG.getSoap_namespace() + "\">\r\n";
                xml = String.valueOf(xml) + "<aAnwendung_Code>SR</aAnwendung_Code>\r\n";
                xml = String.valueOf(xml) + "<aSprache_Art>" + Art + "</aSprache_Art>\r\n";
                xml = String.valueOf(xml) + "<returnFehler></returnFehler>\r\n";
                xml = String.valueOf(xml) + "</getSprachen_per_Anwendung>\r\n";
                is = this.action("srStammdaten", "getSprachen_per_Anwendung", xml);
                FileOutputStream fostmp = new FileOutputStream(f);
                byte[] buftmp = new byte[1024];
                int itmp = 0;
                while ((itmp = is.read(buftmp)) != -1) {
                    fostmp.write(buftmp, 0, itmp);
                }
                fostmp.close();
                is.reset();
            } else {
                is = new FileInputStream(f);
            }
            Document doc = builder.build(is);
            Namespace diffgr = Namespace.getNamespace((String)"diffgr", (String)"urn:schemas-microsoft-com:xml-diffgram-v1");
            Namespace soap = Namespace.getNamespace((String)"soap12", (String)"http://www.w3.org/2003/05/soap-envelope");
            Namespace own = Namespace.getNamespace((String)("http://" + this.CONFIG.getSoap_namespace()));
            Element root = doc.getRootElement();
            Element Body = root.getChild("Body", soap);
            Element response = Body.getChild("getSprachen_per_AnwendungResponse", own);
            Element result = response.getChild("getSprachen_per_AnwendungResult", own);
            String fehler = response.getChildText("returnFehler", own);
            if (fehler.equals("")) {
                List sprachenlist = result.getChildren("structSprache", own);
                Iterator sprachen = sprachenlist.iterator();
                while (sprachen.hasNext()) {
                    Element sprache = (Element)sprachen.next();
                    Sprache sp = new Sprache(sprache.getChildText("ID", own), sprache.getChildText("Bezeichnung", own), sprache.getChildText("Kurzzeichen", own));
                    res.add(sp);
                }
            } else {
                res.add(new Sprache("1", "deutsch", "D"));
                res.add(new Sprache("4", "fran\u00e7ais", "F"));
            }
        }
        catch (IOException e) {
            res.add(new Sprache("1", "deutsch", "D"));
            res.add(new Sprache("4", "fran\u00e7ais", "F"));
        }
        catch (JDOMException e) {
            res.add(new Sprache("1", "deutsch", "D"));
            res.add(new Sprache("4", "fran\u00e7ais", "F"));
        }
        return res;
    }

    public static String getXMLString(String text) {
        text = text.replaceAll("&", "&amp;");
        return WebService.getEncodedString(text, "UTF-8");
    }

    public static String getEncodedString(String text, String encoding) {
        try {
            return new String(text.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            return text;
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = WebService.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

