/*
 * Decompiled with CFR 0.152.
 */
package testtool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import org.jdom.JDOMException;
import res.Config;
import res.LicFile;
import res.WebService;
import testtool.Commandline;
import testtool.KontaktDialog;

public class TestTool
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTextPane text = null;
    private JPanel pnl_bottom = null;
    private JButton btn_start = null;
    private JButton btn_save = null;
    private JButton btn_send = null;
    private JButton btn_close = null;
    private Config CONFIG;
    private JFrame frame;
    private String statustext = "";

    public TestTool(Config config) {
        this.CONFIG = config;
        this.frame = this;
        this.initialize();
        this.addWindowListener(new WindowAdapterImpl());
    }

    private void initialize() {
        this.setBounds(new Rectangle(80, 50, 800, 600));
        this.setResizable(false);
        this.setTitle("Java Test Tool");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getText(), "Center");
            this.jContentPane.add((Component)this.getPnl_bottom(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getText() {
        this.text = new JTextPane();
        this.text.setFont(new Font("Monospaced", 0, 12));
        this.text.setText(String.valueOf(this.getTrenner("=")) + "Klicken Sie auf Start um die Test durchzuf\u00fchren.\n" + this.getTrenner("-"));
        this.text.setEditable(false);
        JScrollPane panel = new JScrollPane();
        panel.setVerticalScrollBarPolicy(20);
        panel.setBorder(null);
        panel.setBackground(Color.white);
        panel.setViewportView(this.text);
        return panel;
    }

    private JPanel getPnl_bottom() {
        if (this.pnl_bottom == null) {
            this.pnl_bottom = new JPanel();
            this.pnl_bottom.setLayout(new BoxLayout(this.pnl_bottom, 0));
            this.pnl_bottom.setPreferredSize(new Dimension(0, 40));
            this.pnl_bottom.add(Box.createHorizontalStrut(20));
            this.pnl_bottom.add(this.getBtn_start());
            this.pnl_bottom.add(Box.createHorizontalStrut(20));
            this.pnl_bottom.add(this.getBtn_save());
            this.pnl_bottom.add(Box.createHorizontalStrut(20));
            this.pnl_bottom.add(this.getBtn_send());
            this.pnl_bottom.add(Box.createHorizontalStrut(20));
            this.pnl_bottom.add(this.getBtn_close());
        }
        return this.pnl_bottom;
    }

    private JButton getBtn_start() {
        if (this.btn_start == null) {
            this.btn_start = new JButton();
            this.btn_start.setPreferredSize(new Dimension(100, 25));
            this.btn_start.setSize(new Dimension(100, 25));
            this.btn_start.setLocation(new Point(382, 8));
            this.btn_start.setText("Start");
            this.btn_start.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TestTool.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                    TestTool.this.btn_start.setEnabled(false);
                    TestTool.this.btn_save.setEnabled(false);
                    TestTool.this.btn_send.setEnabled(false);
                    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                    TestTool.this.statustext = String.valueOf(TestTool.this.getTrenner("=")) + "ALLGEMEIN\n" + TestTool.this.getTrenner("-") + " Datum:              " + df.format(new Date()) + "\n" + " Version:            " + TestTool.this.CONFIG.getAPPNAME() + " / " + TestTool.this.CONFIG.getVERSION() + "\n" + TestTool.this.getTrenner("=") + "\n" + TestTool.this.getConfigInfos() + "\n" + TestTool.this.getFileInfos() + "\n" + TestTool.this.getSystemInfos() + "\n" + TestTool.this.getNetworkInfos();
                    TestTool.this.text.setText(TestTool.this.statustext);
                    TestTool.this.btn_start.setEnabled(true);
                    TestTool.this.btn_save.setEnabled(true);
                    TestTool.this.btn_send.setEnabled(true);
                    TestTool.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                    KontaktDialog k = new KontaktDialog(TestTool.this.frame, TestTool.this.CONFIG, TestTool.this.statustext);
                    k.setVisible(true);
                }
            });
        }
        return this.btn_start;
    }

    private JButton getBtn_save() {
        if (this.btn_save == null) {
            this.btn_save = new JButton();
            this.btn_save.setPreferredSize(new Dimension(100, 25));
            this.btn_save.setSize(new Dimension(100, 25));
            this.btn_save.setLocation(new Point(382, 8));
            this.btn_save.setText("Resultate speichern");
            this.btn_save.setEnabled(false);
            this.btn_save.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JFileChooser fc = new JFileChooser();
                    fc.addChoosableFileFilter(new FileFilter(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return true;
                            }
                            return f.getName().toLowerCase().endsWith(".txt");
                        }

                        public String getDescription() {
                            return "Textfile";
                        }
                    });
                    fc.setMultiSelectionEnabled(false);
                    if (fc.showSaveDialog(TestTool.this.frame) == 0) {
                        File datei = fc.getSelectedFile();
                        if (!datei.getAbsolutePath().toLowerCase().endsWith(".txt")) {
                            datei = new File(datei.getAbsoluteFile() + ".txt");
                        }
                        int check = 0;
                        if (datei.exists()) {
                            check = JOptionPane.showConfirmDialog(TestTool.this.frame, "Wollen Sie die Datei \u00fcberschreiben?", "Datei existiert bereits", 0);
                        }
                        if (check == 0) {
                            try {
                                try {
                                    TestTool.this.text.write(new FileWriter(datei));
                                }
                                catch (IOException e1) {
                                    JOptionPane.showMessageDialog(TestTool.this.frame, "Fehler beim erstellen der Datei. Bitte versuchen Sie es noch einmal.");
                                    JOptionPane.showMessageDialog(TestTool.this.frame, "Die Resultate wurden erfolgreich gespeichert");
                                }
                            }
                            finally {
                                JOptionPane.showMessageDialog(TestTool.this.frame, "Die Resultate wurden erfolgreich gespeichert");
                            }
                        }
                    }
                }
            });
        }
        return this.btn_save;
    }

    private JButton getBtn_send() {
        if (this.btn_send == null) {
            this.btn_send = new JButton();
            this.btn_send.setPreferredSize(new Dimension(100, 25));
            this.btn_send.setSize(new Dimension(100, 25));
            this.btn_send.setLocation(new Point(382, 8));
            this.btn_send.setText("Resultate an Support senden");
            this.btn_send.setEnabled(false);
            this.btn_send.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    KontaktDialog k = new KontaktDialog(TestTool.this.frame, TestTool.this.CONFIG, TestTool.this.statustext);
                    k.setVisible(true);
                }
            });
        }
        return this.btn_send;
    }

    private JButton getBtn_close() {
        if (this.btn_close == null) {
            this.btn_close = new JButton();
            this.btn_close.setPreferredSize(new Dimension(100, 25));
            this.btn_close.setSize(new Dimension(100, 25));
            this.btn_close.setLocation(new Point(382, 8));
            this.btn_close.setText("Beenden");
            this.btn_close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.btn_close;
    }

    private String getTrenner(String zeichen) {
        if (zeichen.equals("=")) {
            return "==============================================================================\n";
        }
        return "------------------------------------------------------------------------------\n";
    }

    private String getConfigInfos() {
        WebService ws = new WebService(this.CONFIG);
        long start = System.currentTimeMillis();
        String result = ws.echo("srBenutzerkonto");
        long stop = System.currentTimeMillis();
        String infos = String.valueOf(this.getTrenner("=")) + "CONFIG-INFOS\n" + this.getTrenner("=") + " Allgemein\n" + this.getTrenner("-") + " Sprache:            " + this.CONFIG.getSprache() + "\n" + " Datenpfad-Lokal:    " + this.CONFIG.getDatenpfad_lokal() + "\n" + " Datenpfad-Zentral:  " + this.CONFIG.getDatenpfad_zentral() + "\n" + " online:             " + this.CONFIG.getOnline() + "\n" + " eventlog:           " + this.CONFIG.getEventlog() + "\n" + " showStartAssistent: " + this.CONFIG.getShowStartAssistent() + "\n" + "\n" + " Webservice\n" + this.getTrenner("-") + " Server:             " + "http://" + this.CONFIG.getSoap_server() + "\n" + " Serverpfad:         " + this.CONFIG.getSoap_serverpfad() + "\n" + " URL:                " + "http://" + this.CONFIG.getSoap_server() + "/" + this.CONFIG.getSoap_serverpfad() + "SERVICENAME.asmx" + "\n" + " Namespace:          " + this.CONFIG.getSoap_namespace() + "\n" + " My-Soap:            " + this.CONFIG.isUseMySoap() + "\n" + " ECHO-Result:        " + result + "\n" + " gebrauchte Zeit:    " + (stop - start) + "\n" + "\n";
        infos = String.valueOf(infos) + " Proxy\n" + this.getTrenner("-") + " Aktiv:              " + this.CONFIG.getProxy_active() + "\n";
        if (this.CONFIG.isProxy_active()) {
            infos = String.valueOf(infos) + " Use IE-Settings:    " + this.CONFIG.getProxy_useiesettings() + "\n";
            if (!this.CONFIG.isProxy_useiesettings()) {
                infos = String.valueOf(infos) + " Host:               " + this.CONFIG.getProxy_host() + "\n" + " Port:               " + this.CONFIG.getProxy_port() + "\n" + " Use User:           " + this.CONFIG.getProxy_useuser() + "\n";
                if (!this.CONFIG.isProxy_useuser()) {
                    infos = String.valueOf(infos) + " User:               " + this.CONFIG.getProxy_user() + "\n" + " Passwort:           " + this.getStars(this.CONFIG.getProxy_pw().length()) + "\n";
                }
            }
        }
        infos = String.valueOf(infos) + this.getTrenner("=");
        return infos;
    }

    private String getFileInfos() {
        String infos = String.valueOf(this.getTrenner("=")) + "FILESYSTEM-INFOS\n" + this.getTrenner("=");
        File f = new File(this.CONFIG.getConfFilePath());
        infos = f.exists() ? String.valueOf(infos) + " Config-File\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Gr\u00f6sse:             " + f.length() + " Byte / " + f.length() / 1024L + " KByte\n" + " Datum:              " + new Date(f.lastModified()) + "\n" + "\n" : String.valueOf(infos) + " Config-File\n" + this.getTrenner("-") + " Datei existiert nicht (" + f.getAbsolutePath() + ")\n\n";
        f = new File(this.CONFIG.getLicFilePath());
        if (f.exists()) {
            infos = String.valueOf(infos) + " Lizenz-File\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Gr\u00f6sse:             " + f.length() + " Byte / " + f.length() / 1024L + " KByte\n" + " Datum:              " + new Date(f.lastModified()) + "\n";
            LicFile LICFILE = new LicFile(this.CONFIG.getLicFilePath(), this.CONFIG);
            try {
                if (LICFILE.open()) {
                    if (LICFILE.checkClient(this.CONFIG.getPID())) {
                        if (LICFILE.showUZwingend()) {
                            infos = String.valueOf(infos) + " Hinweis:            Lizenzfile ist zu alt und muss aktualisiert werden\n";
                        } else {
                            if (LICFILE.showUMeldung()) {
                                infos = String.valueOf(infos) + " Hinweis:            Lizenzfile ist \u00e4lter als 30 Tage und sollte aktualisiert werden\n";
                            }
                            infos = String.valueOf(infos) + " Hinweis:            Lizenzfile konnte korrekt ge\u00f6ffnet werden\n";
                            this.CONFIG.setLICFILE(LICFILE);
                            this.CONFIG.setUserLoggedIn(true);
                        }
                    } else {
                        infos = String.valueOf(infos) + " Fehler:             Aktuelles Ger\u00e4t wurde noch nicht registriert (" + this.CONFIG.getPID() + ")\n";
                    }
                } else {
                    infos = String.valueOf(infos) + " Fehler:             Pr\u00fcfsumme stimmt nicht\n";
                }
            }
            catch (ZipException e1) {
                infos = String.valueOf(infos) + " Fehler:             ZipException\n";
            }
            catch (IOException e1) {
                infos = String.valueOf(infos) + " Fehler:             IOException\n";
            }
            catch (JDOMException e1) {
                infos = String.valueOf(infos) + " Fehler:             JDOMException\n";
            }
            infos = String.valueOf(infos) + "\n";
        } else {
            infos = String.valueOf(infos) + " Lizenz-File\n" + this.getTrenner("-") + " Datei existiert nicht (" + f.getAbsolutePath() + ")\n\n";
        }
        f = new File(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + this.CONFIG.getProvider() + "Labels.xml");
        infos = f.exists() ? String.valueOf(infos) + " Labels-File\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Gr\u00f6sse:             " + f.length() + " Byte / " + f.length() / 1024L + " KByte\n" + " Datum:              " + new Date(f.lastModified()) + "\n" + "\n" : String.valueOf(infos) + " Labels-File\n" + this.getTrenner("-") + " Datei existiert nicht (" + f.getAbsolutePath() + ")\n\n";
        f = new File(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + this.CONFIG.getProvider() + "Links.xml");
        infos = f.exists() ? String.valueOf(infos) + " Links-File\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Gr\u00f6sse:             " + f.length() + " Byte / " + f.length() / 1024L + " KByte\n" + " Datum:              " + new Date(f.lastModified()) + "\n" + "\n" : String.valueOf(infos) + " Links-File\n" + this.getTrenner("-") + " Datei existiert nicht (" + f.getAbsolutePath() + ")\n\n";
        f = new File(this.CONFIG.getDatenpfad_lokal());
        File testfile = new File(String.valueOf(this.CONFIG.getDatenpfad_lokal()) + System.getProperty("file.separator") + "Testfile.txt");
        infos = String.valueOf(infos) + " Lokale Dateiablage\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Datei erstellen:    ";
        try {
            infos = String.valueOf(infos) + testfile.createNewFile() + "\n";
        }
        catch (IOException e) {
            infos = String.valueOf(infos) + " FEHLER: " + e.getMessage() + "\n";
        }
        if (testfile.exists()) {
            infos = String.valueOf(infos) + " Datei l\u00f6schen:      " + testfile.delete() + "\n";
        }
        infos = String.valueOf(infos) + "\n";
        if (!this.CONFIG.getDatenpfad_zentral().equals("")) {
            f = new File(this.CONFIG.getDatenpfad_zentral());
            testfile = new File(String.valueOf(this.CONFIG.getDatenpfad_zentral()) + System.getProperty("file.separator") + "Testfile.txt");
            infos = String.valueOf(infos) + " Zentrale Dateiablage\n" + this.getTrenner("-") + " Pfad:               " + f.getAbsolutePath() + "\n" + " Datei erstellen:    ";
            try {
                infos = String.valueOf(infos) + testfile.createNewFile() + "\n";
            }
            catch (IOException e) {
                infos = String.valueOf(infos) + "FEHLER: " + e.getMessage() + "\n";
            }
            if (testfile.exists()) {
                infos = String.valueOf(infos) + " Datei l\u00f6schen:      " + testfile.delete() + "\n";
            }
        } else {
            infos = String.valueOf(infos) + " Zentrale Dateiablage\n" + this.getTrenner("-") + " (nicht gesetzt)\n";
        }
        infos = String.valueOf(infos) + this.getTrenner("=");
        return infos;
    }

    private String getNetworkInfos() {
        Commandline cl = new Commandline();
        String infos = String.valueOf(this.getTrenner("=")) + "NETWORK-TESTS\n" + this.getTrenner("=") + "Ping Check-Host (" + this.CONFIG.getCheckHost() + ")\n" + this.getTrenner("-") + cl.execPing(this.CONFIG.getCheckHost()) + this.getTrenner("-") + "Ping Webservie-Host (" + this.CONFIG.getSoap_server() + ")\n" + this.getTrenner("-") + cl.execPing(this.CONFIG.getSoap_server());
        if (this.CONFIG.isProxy_active()) {
            infos = String.valueOf(infos) + this.getTrenner("-") + "Ping Proxy-Host (" + this.CONFIG.getProxy_host() + ")\n" + this.getTrenner("-") + cl.execPing(this.CONFIG.getProxy_host());
        }
        infos = String.valueOf(infos) + this.getTrenner("-") + "Traceroute zu Check-Host (" + this.CONFIG.getCheckHost() + ")\n" + this.getTrenner("-") + cl.execTraceroute(this.CONFIG.getCheckHost()) + this.getTrenner("-") + "Traceroute zu Webservie-Host (" + this.CONFIG.getSoap_server() + ")\n" + this.getTrenner("-") + cl.execTraceroute(this.CONFIG.getSoap_server());
        if (this.CONFIG.isProxy_active()) {
            infos = String.valueOf(infos) + this.getTrenner("-") + "Traceroute zu Proxy-Host (" + this.CONFIG.getProxy_host() + ")\n" + this.getTrenner("-") + cl.execTraceroute(this.CONFIG.getProxy_host());
        }
        infos = String.valueOf(infos) + this.getTrenner("=");
        return infos;
    }

    private String getSystemInfos() {
        String infos = String.valueOf(this.getTrenner("=")) + "SYSTEM\n" + this.getTrenner("=") + " OS-Name:            " + System.getProperty("os.name") + "\n" + " OS-Arch:            " + System.getProperty("os.arch") + "\n" + " OS-Version:         " + System.getProperty("os.version") + "\n" + this.getTrenner("-") + " User-Name:          " + System.getProperty("user.name") + "\n" + " User-Home:          " + System.getProperty("user.home") + "\n" + " User-Language:      " + System.getProperty("user.language") + "\n" + this.getTrenner("-") + " App-Pfad:           " + System.getProperty("user.dir") + "\n" + " User-Pfad:          " + this.CONFIG.getUserDataDir() + "\n" + " Encoding:           " + System.getProperty("file.encoding") + "\n" + this.getTrenner("-") + " Java-Version:       " + System.getProperty("java.version") + "\n" + " Java-Vendor:        " + System.getProperty("java.vendor") + "\n" + " Java-VM-Version:    " + System.getProperty("java.vm.version") + "\n" + " Java-VM-Vendor:     " + System.getProperty("java.vm.vendor") + "\n" + " Classpath:          " + System.getProperty("java.class.path") + "\n" + this.getTrenner("=");
        return infos;
    }

    private String getStars(int len) {
        String tmp = "";
        int i = 0;
        while (i < len) {
            tmp = String.valueOf(tmp) + "*";
            ++i;
        }
        return tmp;
    }

    class WindowAdapterImpl
    extends WindowAdapter {
        WindowAdapterImpl() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

