/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import java.util.Locale;
import javax.imageio.ImageWriteParam;

final class CLibJPEGImageWriteParam
extends ImageWriteParam {
    private static final float DEFAULT_COMPRESSION_QUALITY = 0.75f;
    static final String LOSSY_COMPRESSION_TYPE = "JPEG";
    static final String LOSSLESS_COMPRESSION_TYPE = "JPEG-LOSSLESS";
    static final String LS_COMPRESSION_TYPE = "JPEG-LS";
    private static final String[] compressionQualityDescriptions = new String[]{I18N.getString("CLibJPEGImageWriteParam0"), I18N.getString("CLibJPEGImageWriteParam1"), I18N.getString("CLibJPEGImageWriteParam2")};

    CLibJPEGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.compressionMode = 2;
        this.compressionQuality = 0.75f;
        this.compressionType = LOSSY_COMPRESSION_TYPE;
        this.compressionTypes = new String[]{LOSSY_COMPRESSION_TYPE, LOSSLESS_COMPRESSION_TYPE, LS_COMPRESSION_TYPE};
    }

    public String[] getCompressionQualityDescriptions() {
        super.getCompressionQualityDescriptions();
        return compressionQualityDescriptions;
    }

    public float[] getCompressionQualityValues() {
        super.getCompressionQualityValues();
        return new float[]{0.05f, 0.75f, 0.95f};
    }

    public boolean isCompressionLossless() {
        super.isCompressionLossless();
        return !this.compressionType.equalsIgnoreCase(LOSSY_COMPRESSION_TYPE);
    }

    public void setCompressionMode(int n) {
        if (n == 0 || n == 3) {
            throw new UnsupportedOperationException("mode == MODE_DISABLED || mode == MODE_COPY_FROM_METADATA");
        }
        super.setCompressionMode(n);
    }

    public void unsetCompression() {
        super.unsetCompression();
        this.compressionQuality = 0.75f;
        this.compressionType = LOSSY_COMPRESSION_TYPE;
    }
}

