/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Encoder;
import com.sun.medialib.codec.jp2k.Params;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NodeList;

public class J2KImageWriterCodecLib
extends ImageWriter {
    public static String WRITE_ABORTED = "Write aborted.";
    private ImageOutputStream stream = null;
    private J2KMetadataFormat format;
    private Encoder encoder;
    private Size size;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] sourceBands = null;
    private int numComp;
    private RenderedImage input;
    private J2KImageWriteParam param;
    private Raster inputRaster;
    private Rectangle destinationRegion = null;
    private SampleModel sampleModel;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private boolean writeRaster = false;

    public J2KImageWriterCodecLib(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("J2KImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new J2KImageWriteParam();
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        List<String> list;
        Object object;
        Object object2;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("J2KImageWriterMedialib1"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriterMedialib2"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        this.encoder = new Encoder(this.stream);
        this.writeRaster = iIOImage.hasRaster();
        ColorModel colorModel = null;
        if (this.writeRaster) {
            this.inputRaster = iIOImage.getRaster();
            this.sampleModel = this.inputRaster.getSampleModel();
        } else {
            this.input = iIOImage.getRenderedImage();
            this.sampleModel = this.input.getSampleModel();
            colorModel = this.input.getColorModel();
        }
        if (imageWriteParam == null) {
            imageWriteParam = new J2KImageWriteParam();
        }
        if (imageWriteParam instanceof J2KImageWriteParam) {
            object2 = (J2KImageWriteParam)imageWriteParam;
            if (!this.writeRaster && this.input.getColorModel() instanceof IndexColorModel) {
                ((J2KImageWriteParam)object2).setLossless(true);
                ((J2KImageWriteParam)object2).setEncodingRate(Double.MAX_VALUE);
                ((J2KImageWriteParam)object2).setFilter("w5x3");
            } else if (((J2KImageWriteParam)object2).getEncodingRate() == Double.MAX_VALUE) {
                ((J2KImageWriteParam)object2).setLossless(true);
                ((J2KImageWriteParam)object2).setFilter("w5x3");
            }
        }
        this.setParameters(imageWriteParam);
        object2 = imageWriteParam.getSourceRegion();
        object2 = object2 == null ? (this.writeRaster ? this.inputRaster.getBounds() : new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight())) : (this.writeRaster ? ((Rectangle)object2).intersection(this.inputRaster.getBounds()) : ((Rectangle)object2).intersection(new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight())));
        if (((Rectangle)object2).isEmpty()) {
            throw new RuntimeException(I18N.getString("J2KImageWriterCodecLib0"));
        }
        try {
            this.tileWidth = imageWriteParam.getTileWidth();
            this.tileHeight = imageWriteParam.getTileHeight();
            this.tileXOffset = imageWriteParam.getTileGridXOffset();
            this.tileYOffset = imageWriteParam.getTileGridYOffset();
        }
        catch (IllegalStateException illegalStateException) {
            imageWriteParam.setTilingMode(2);
            if (this.writeRaster) {
                imageWriteParam.setTiling(this.inputRaster.getWidth(), this.inputRaster.getHeight(), this.inputRaster.getMinX(), this.inputRaster.getMinY());
            } else {
                imageWriteParam.setTiling(this.input.getTileWidth(), this.input.getTileHeight(), this.input.getTileGridXOffset(), this.input.getTileGridYOffset());
            }
            this.tileWidth = imageWriteParam.getTileWidth();
            this.tileHeight = imageWriteParam.getTileHeight();
            this.tileXOffset = imageWriteParam.getTileGridXOffset();
            this.tileYOffset = imageWriteParam.getTileGridYOffset();
        }
        this.scaleX = imageWriteParam.getSourceXSubsampling();
        this.scaleY = imageWriteParam.getSourceYSubsampling();
        this.xOffset = imageWriteParam.getSubsamplingXOffset();
        this.yOffset = imageWriteParam.getSubsamplingYOffset();
        ((Rectangle)object2).translate(this.xOffset, this.yOffset);
        ((Rectangle)object2).width -= this.xOffset;
        ((Rectangle)object2).height -= this.yOffset;
        this.xOffset = ((Rectangle)object2).x % this.scaleX;
        this.yOffset = ((Rectangle)object2).y % this.scaleY;
        int n = ((Rectangle)object2).x / this.scaleX;
        int n2 = ((Rectangle)object2).y / this.scaleY;
        int n3 = (((Rectangle)object2).width + this.scaleX - 1) / this.scaleX;
        int n4 = (((Rectangle)object2).height + this.scaleY - 1) / this.scaleY;
        this.tileXOffset += (n - this.tileXOffset) / this.tileWidth * this.tileWidth;
        this.tileYOffset += (n2 - this.tileYOffset) / this.tileHeight * this.tileHeight;
        this.destinationRegion = new Rectangle(n, n2, n3, n4);
        if (!this.destinationRegion.equals(object2) || this.tileWidth != this.sampleModel.getWidth() || this.tileHeight != this.sampleModel.getHeight() || !this.writeRaster && (this.tileXOffset != this.input.getTileGridXOffset() || this.tileYOffset != this.input.getTileGridYOffset()) || this.writeRaster && (this.tileXOffset != this.inputRaster.getMinX() || this.tileYOffset != this.inputRaster.getMinY())) {
            this.noTransform = false;
        }
        this.numComp = this.sampleModel.getNumBands();
        this.sourceBands = imageWriteParam.getSourceBands();
        if (this.sourceBands != null) {
            this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            colorModel = null;
            this.noSubband = false;
        } else {
            this.sourceBands = new int[this.numComp];
            for (int i = 0; i < this.numComp; ++i) {
                this.sourceBands[i] = i;
            }
        }
        this.numComp = this.sourceBands.length;
        this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.setSize();
        this.setCompParameters(colorModel, this.sampleModel, imageWriteParam);
        this.encoder.setMode(2);
        if (!((J2KImageWriteParam)imageWriteParam).getWriteCodeStreamOnly()) {
            IIOMetadata iIOMetadata2 = iIOImage.getMetadata();
            J2KMetadata j2KMetadata = new J2KMetadata(colorModel, this.sampleModel, this.destinationRegion.width, this.destinationRegion.height, imageWriteParam, this);
            object = null;
            if (iIOMetadata2 == null) {
                object = j2KMetadata;
            } else {
                Object object3;
                if (colorModel != null) {
                    object3 = new ImageTypeSpecifier(colorModel, this.sampleModel);
                    object = (J2KMetadata)this.convertImageMetadata(iIOMetadata2, (ImageTypeSpecifier)object3, imageWriteParam);
                } else {
                    object3 = null;
                    list = Arrays.asList(iIOMetadata2.getMetadataFormatNames());
                    if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                        object3 = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
                    } else if (iIOMetadata2.isStandardMetadataFormatSupported()) {
                        object3 = "javax_imageio_1.0";
                    }
                    object = new J2KMetadata();
                    if (object3 != null) {
                        ((J2KMetadata)object).setFromTree((String)object3, iIOMetadata2.getAsTree((String)object3));
                    }
                }
                ((J2KMetadata)object).mergeTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0", j2KMetadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0"));
            }
            this.writeMetadata((J2KMetadata)object);
        } else {
            this.encoder.setEncodeCodeStreamOnly();
        }
        for (int i = this.getMinTileY(); i <= this.getMaxTileY(); ++i) {
            for (int j = this.getMinTileX(); j <= this.getMaxTileX(); ++j) {
                object = this.getTile(j, i);
                int n5 = MediaLibAccessor.findCompatibleTag((Raster)object);
                list = new MediaLibAccessor((Raster)object, ((Raster)object).getBounds(), n5, true);
                mediaLibImage[] mediaLibImageArray = ((MediaLibAccessor)((Object)list)).getMediaLibImages();
                this.encoder.encode(mediaLibImageArray, j + i * this.size.nxtiles);
                float f = ((float)(j + i * this.size.nxtiles) + 1.0f) / (float)(this.size.nxtiles * this.size.nytiles);
                this.processImageProgress(f * 100.0f);
            }
        }
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new J2KMetadata(imageTypeSpecifier, imageWriteParam, this);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        if (iIOMetadata == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageTypeSpecifier == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (iIOMetadata instanceof J2KMetadata) {
            return (IIOMetadata)((J2KMetadata)iIOMetadata).clone();
        }
        try {
            J2KMetadata j2KMetadata = new J2KMetadata();
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            String string = null;
            if (list.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                string = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                string = "javax_imageio_1.0";
            }
            if (string != null) {
                j2KMetadata.setFromTree(string, iIOMetadata.getAsTree(string));
                return j2KMetadata;
            }
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            return null;
        }
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public synchronized void abort() {
        super.abort();
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private void checkSampleModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter5"));
        }
        if (sampleModel.getNumBands() > 16384) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter6"));
        }
    }

    private void writeMetadata(J2KMetadata j2KMetadata) throws IOException {
        if (j2KMetadata == null) {
            return;
        }
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)j2KMetadata.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        if (iIOMetadataNode == null) {
            return;
        }
        this.format = (J2KMetadataFormat)j2KMetadata.getMetadataFormat("com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        this.writeSuperBox(iIOMetadataNode);
    }

    private void writeSuperBox(IIOMetadataNode iIOMetadataNode) throws IOException {
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        String string = iIOMetadataNode.getNodeName();
        if (string.startsWith("JPEG2000")) {
            // empty if block
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            string = iIOMetadataNode2.getNodeName();
            if (string.startsWith("JPEG2000") && this.format.isLeaf(string)) {
                this.writeBox(iIOMetadataNode2);
                continue;
            }
            this.writeSuperBox(iIOMetadataNode2);
        }
    }

    private void writeBox(IIOMetadataNode iIOMetadataNode) throws IOException {
        com.sun.medialib.codec.jp2k.Box box = new com.sun.medialib.codec.jp2k.Box();
        box.type = Box.getTypeInt((String)Box.getAttribute(iIOMetadataNode, "Type"));
        Box box2 = Box.createBox(box.type, iIOMetadataNode);
        box.data = box2.getContent();
        this.encoder.encodeBox(box);
    }

    private int computeLength(IIOMetadataNode iIOMetadataNode) {
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            String string = iIOMetadataNode2.getNodeName();
            if (this.format.isLeaf(string)) {
                String string2 = (String)Box.getAttribute(iIOMetadataNode2, "Length");
                n += new Integer(string2).intValue();
                continue;
            }
            n += this.computeLength(iIOMetadataNode2);
        }
        return n + (iIOMetadataNode.getNodeName().startsWith("JPEG2000") ? 8 : 0);
    }

    private int generateSuperBoxContent(IIOMetadataNode iIOMetadataNode, byte[] byArray, int n) throws IOException {
        int n2;
        String string = iIOMetadataNode.getNodeName();
        if (string.startsWith("JPEG2000")) {
            int n3 = this.computeLength(iIOMetadataNode);
            Box.copyInt(byArray, n, n3);
            n2 = Box.getTypeInt(Box.getTypeByName(string));
            Box.copyInt(byArray, n += 4, n2);
            n += 4;
        }
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(n2);
            string = iIOMetadataNode2.getNodeName();
            if (this.format.isLeaf(string)) {
                int n4 = Box.getTypeInt((String)Box.getAttribute(iIOMetadataNode2, "Type"));
                Box box = Box.createBox(n4, iIOMetadataNode2);
                byte[] byArray2 = box.getContent();
                Box.copyInt(byArray, n, byArray2.length + 8);
                Box.copyInt(byArray, n += 4, n4);
                System.arraycopy(byArray2, 0, byArray, n += 4, byArray2.length);
                n += byArray2.length;
                continue;
            }
            n = this.generateSuperBoxContent(iIOMetadataNode2, byArray, n);
        }
        return n;
    }

    private Raster getTile(int n, int n2) {
        int n3 = this.tileXOffset + n * this.tileWidth;
        int n4 = this.tileYOffset + n2 * this.tileHeight;
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        if (this.writeRaster) {
            rectangle = rectangle.intersection(this.destinationRegion);
            if (this.noTransform) {
                return this.inputRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
            }
            n3 = rectangle.x;
            n4 = rectangle.y;
            WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
            int n5 = this.mapToSourceX(n3);
            int n6 = this.mapToSourceY(n4);
            int n7 = this.inputRaster.getMinY();
            int n8 = this.inputRaster.getMinY() + this.inputRaster.getHeight();
            int n9 = rectangle.width;
            int n10 = (n9 - 1) * this.scaleX + 1;
            int n11 = 0;
            while (n11 < rectangle.height) {
                if (n6 >= n7 && n6 < n8) {
                    Raster raster = this.inputRaster.createChild(n5, n6, n10, 1, n5, n6, null);
                    int n12 = n3;
                    int n13 = 0;
                    int n14 = n5;
                    while (n13 < n9) {
                        for (int i = 0; i < this.numComp; ++i) {
                            int n15 = raster.getSample(n14, n6, this.sourceBands[i]);
                            writableRaster.setSample(n12, n4, i, n15);
                        }
                        ++n13;
                        ++n12;
                        n14 += this.scaleX;
                    }
                }
                ++n11;
                ++n4;
                n6 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.input.getTile(n, n2);
            if (this.destinationRegion.contains(rectangle) && this.noSubband) {
                return raster;
            }
            rectangle = rectangle.intersection(this.destinationRegion);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
        }
        rectangle = rectangle.intersection(this.destinationRegion);
        n3 = rectangle.x;
        n4 = rectangle.y;
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        int n16 = this.mapToSourceX(n3);
        int n17 = this.mapToSourceY(n4);
        int n18 = this.input.getMinY();
        int n19 = this.input.getMinY() + this.input.getHeight();
        int n20 = rectangle.width;
        int n21 = (n20 - 1) * this.scaleX + 1;
        int n22 = 0;
        while (n22 < rectangle.height) {
            if (n17 >= n18 && n17 < n19) {
                Raster raster = this.input.getData(new Rectangle(n16, n17, n21, 1));
                int n23 = n3;
                int n24 = 0;
                int n25 = n16;
                while (n24 < n20) {
                    for (int i = 0; i < this.numComp; ++i) {
                        int n26 = raster.getSample(n25, n17, this.sourceBands[i]);
                        writableRaster.setSample(n23, n4, i, n26);
                    }
                    ++n24;
                    ++n23;
                    n25 += this.scaleX;
                }
            }
            ++n22;
            ++n4;
            n17 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n) {
        return n * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n) {
        return n * this.scaleY + this.yOffset;
    }

    private int getMinTileX() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.x, this.tileXOffset, this.tileWidth);
    }

    private int getMaxTileX() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.x + this.destinationRegion.width - 1, this.tileXOffset, this.tileWidth);
    }

    private int getMinTileY() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.y, this.tileYOffset, this.tileHeight);
    }

    private int getMaxTileY() {
        return J2KImageWriterCodecLib.ToTile(this.destinationRegion.y + this.destinationRegion.height - 1, this.tileYOffset, this.tileHeight);
    }

    private static int ToTile(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    private void setSize() {
        this.size = new Size();
        this.size.csize = this.numComp;
        this.size.nxtiles = this.getMaxTileX() - this.getMinTileX() + 1;
        this.size.nytiles = this.getMaxTileY() - this.getMinTileY() + 1;
        this.size.xosize = this.destinationRegion.x;
        this.size.yosize = this.destinationRegion.y;
        this.size.xsize = this.destinationRegion.width + this.destinationRegion.x;
        this.size.ysize = this.destinationRegion.height + this.destinationRegion.y;
        this.size.xtosize = this.tileXOffset;
        this.size.ytosize = this.tileYOffset;
        this.size.xtsize = this.tileWidth;
        this.size.ytsize = this.tileHeight;
        this.encoder.setSize(this.size);
    }

    private void setCompParameters(ColorModel colorModel, SampleModel sampleModel, ImageWriteParam imageWriteParam) {
        if (!(colorModel != null || sampleModel != null || imageWriteParam != null && imageWriteParam instanceof J2KImageWriteParam)) {
            return;
        }
        int[] nArray = null;
        boolean bl = false;
        if (colorModel != null) {
            nArray = colorModel.getComponentSize();
            bl = colorModel.getTransferType() == 2;
        } else if (sampleModel != null) {
            nArray = sampleModel.getSampleSize();
            bl = sampleModel.getDataType() == 2;
        }
        int n = -1;
        if (imageWriteParam != null) {
            n = ((J2KImageWriteParam)imageWriteParam).getNumDecompositionLevels();
        }
        if (nArray == null && n == -1) {
            return;
        }
        boolean bl2 = false;
        if (nArray != null) {
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == nArray[0]) continue;
                bl2 = true;
                break;
            }
        }
        CompParams compParams = this.encoder.getCompParams(null, -1);
        if (n != -1 && n != compParams.maxlvls || nArray != null && ((bl ? 128 : 0) | nArray[0] - 1) != compParams.depth) {
            if (n != -1) {
                compParams.maxlvls = n;
            }
            if (nArray != null) {
                compParams.depth = (bl ? 128 : 0) | nArray[0] - 1;
            }
            this.encoder.setCompParams(compParams, -1);
        }
        if (bl2) {
            for (int i = 0; i < this.numComp; ++i) {
                compParams = this.encoder.getCompParams(null, i);
                if (n != -1) {
                    compParams.maxlvls = n;
                }
                compParams.depth = (bl ? 128 : 0) | nArray[i] - 1;
                this.encoder.setCompParams(compParams, i);
            }
        }
    }

    private void setParameters(ImageWriteParam imageWriteParam) {
        if (imageWriteParam == null || !(imageWriteParam instanceof J2KImageWriteParam)) {
            return;
        }
        J2KImageWriteParam j2KImageWriteParam = (J2KImageWriteParam)imageWriteParam;
        double d = j2KImageWriteParam.getEncodingRate();
        if (d != Double.MAX_VALUE) {
            this.encoder.setRate(d /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        } else {
            this.encoder.setRate(0.0, 0);
        }
        Params params = new Params();
        int n = params.enablemct = j2KImageWriteParam.getComponentTransformation() ? 1 : 0;
        if (j2KImageWriteParam.getEPH()) {
            params.cstyle |= 4;
        }
        if (j2KImageWriteParam.getSOP()) {
            params.cstyle |= 2;
        }
        if ("w5x3".equals(j2KImageWriteParam.getFilter())) {
            params.wavemode = 1;
        } else if ("w9x7".equals(j2KImageWriteParam.getFilter())) {
            params.wavemode = 0;
        }
        String string = j2KImageWriteParam.getProgressionType();
        if ("layer".equals(string)) {
            params.prgorder = 0;
        }
        if ("res".equals(string)) {
            params.prgorder = 1;
        }
        if ("res-pos".equals(string)) {
            params.prgorder = 2;
        }
        if ("pos-comp".equals(string)) {
            params.prgorder = 3;
        }
        if ("comp-pos".equals(string)) {
            params.prgorder = 4;
        }
        this.encoder.setParams(params);
    }
}

